/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.audience;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.Audiences;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.pointer.Pointer;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.TitlePart;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.UnknownNullability;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface ForwardingAudience
extends Audience {
    @ApiStatus.OverrideOnly
    public Iterable<? extends Audience> audiences();

    @Override
    default public Pointers pointers() {
        return Pointers.empty();
    }

    @Override
    default public Audience filterAudience(Predicate<? super Audience> filter) {
        @Nullable ArrayList<Audience> audiences = null;
        for (Audience audience : this.audiences()) {
            Audience filtered;
            if (!filter.test(audience) || (filtered = audience.filterAudience(filter)) == Audience.empty()) continue;
            if (audiences == null) {
                audiences = new ArrayList<Audience>();
            }
            audiences.add(filtered);
        }
        return audiences != null ? Audience.audience(audiences) : Audience.empty();
    }

    @Override
    default public void forEachAudience(Consumer<? super Audience> action) {
        for (Audience audience : this.audiences()) {
            audience.forEachAudience(action);
        }
    }

    @Override
    default public void sendMessage(Component message) {
        for (Audience audience : this.audiences()) {
            audience.sendMessage(message);
        }
    }

    @Override
    default public void sendMessage(Component message, ChatType.Bound boundChatType) {
        for (Audience audience : this.audiences()) {
            audience.sendMessage(message, boundChatType);
        }
    }

    @Override
    default public void sendMessage(SignedMessage signedMessage, ChatType.Bound boundChatType) {
        for (Audience audience : this.audiences()) {
            audience.sendMessage(signedMessage, boundChatType);
        }
    }

    @Override
    default public void deleteMessage(SignedMessage.Signature signature) {
        for (Audience audience : this.audiences()) {
            audience.deleteMessage(signature);
        }
    }

    @Override
    default public void sendActionBar(Component message) {
        for (Audience audience : this.audiences()) {
            audience.sendActionBar(message);
        }
    }

    @Override
    default public void sendPlayerListHeader(Component header) {
        for (Audience audience : this.audiences()) {
            audience.sendPlayerListHeader(header);
        }
    }

    @Override
    default public void sendPlayerListFooter(Component footer) {
        for (Audience audience : this.audiences()) {
            audience.sendPlayerListFooter(footer);
        }
    }

    @Override
    default public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        for (Audience audience : this.audiences()) {
            audience.sendPlayerListHeaderAndFooter(header, footer);
        }
    }

    @Override
    default public <T> void sendTitlePart(TitlePart<T> part, T value) {
        for (Audience audience : this.audiences()) {
            audience.sendTitlePart(part, value);
        }
    }

    @Override
    default public void clearTitle() {
        for (Audience audience : this.audiences()) {
            audience.clearTitle();
        }
    }

    @Override
    default public void resetTitle() {
        for (Audience audience : this.audiences()) {
            audience.resetTitle();
        }
    }

    @Override
    default public void showBossBar(BossBar bar) {
        for (Audience audience : this.audiences()) {
            audience.showBossBar(bar);
        }
    }

    @Override
    default public void hideBossBar(BossBar bar) {
        for (Audience audience : this.audiences()) {
            audience.hideBossBar(bar);
        }
    }

    @Override
    default public void playSound(Sound sound) {
        for (Audience audience : this.audiences()) {
            audience.playSound(sound);
        }
    }

    @Override
    default public void playSound(Sound sound, double x, double y, double z) {
        for (Audience audience : this.audiences()) {
            audience.playSound(sound, x, y, z);
        }
    }

    @Override
    default public void playSound(Sound sound, Sound.Emitter emitter) {
        for (Audience audience : this.audiences()) {
            audience.playSound(sound, emitter);
        }
    }

    @Override
    default public void stopSound(SoundStop stop) {
        for (Audience audience : this.audiences()) {
            audience.stopSound(stop);
        }
    }

    @Override
    default public void openBook(Book book) {
        for (Audience audience : this.audiences()) {
            audience.openBook(book);
        }
    }

    @Override
    default public void sendResourcePacks(ResourcePackRequest request) {
        for (Audience audience : this.audiences()) {
            audience.sendResourcePacks(request);
        }
    }

    @Override
    default public void removeResourcePacks(Iterable<UUID> ids) {
        for (Audience audience : this.audiences()) {
            audience.removeResourcePacks(ids);
        }
    }

    @Override
    default public void removeResourcePacks(UUID id, UUID ... others) {
        for (Audience audience : this.audiences()) {
            audience.removeResourcePacks(id, others);
        }
    }

    @Override
    default public void clearResourcePacks() {
        for (Audience audience : this.audiences()) {
            audience.clearResourcePacks();
        }
    }

    @Override
    default public void showDialog(DialogLike dialog) {
        for (Audience audience : this.audiences()) {
            audience.showDialog(dialog);
        }
    }

    @Override
    default public void closeDialog() {
        for (Audience audience : this.audiences()) {
            audience.closeDialog();
        }
    }

    public static interface Single
    extends ForwardingAudience {
        @ApiStatus.OverrideOnly
        public Audience audience();

        @Override
        @Deprecated
        default public Iterable<? extends Audience> audiences() {
            return Collections.singleton(this.audience());
        }

        @Override
        default public <T> Optional<T> get(Pointer<T> pointer) {
            return this.audience().get(pointer);
        }

        @Override
        @Contract(value="_, null -> null; _, !null -> !null")
        default public <T> @Nullable T getOrDefault(Pointer<T> pointer, @Nullable T defaultValue) {
            return this.audience().getOrDefault(pointer, defaultValue);
        }

        @Override
        default public <T> @UnknownNullability T getOrDefaultFrom(Pointer<T> pointer, Supplier<? extends T> defaultValue) {
            return this.audience().getOrDefaultFrom(pointer, defaultValue);
        }

        @Override
        default public Audience filterAudience(Predicate<? super Audience> filter) {
            Audience audience = this.audience();
            return filter.test(audience) ? this : Audience.empty();
        }

        @Override
        default public void forEachAudience(Consumer<? super Audience> action) {
            this.audience().forEachAudience(action);
        }

        @Override
        default public Pointers pointers() {
            return this.audience().pointers();
        }

        @Override
        default public void sendMessage(Component message) {
            this.audience().sendMessage(message);
        }

        @Override
        default public void sendMessage(Component message, ChatType.Bound boundChatType) {
            this.audience().sendMessage(message, boundChatType);
        }

        @Override
        default public void sendMessage(SignedMessage signedMessage, ChatType.Bound boundChatType) {
            this.audience().sendMessage(signedMessage, boundChatType);
        }

        @Override
        default public void deleteMessage(SignedMessage.Signature signature) {
            this.audience().deleteMessage(signature);
        }

        @Override
        default public void sendActionBar(Component message) {
            this.audience().sendActionBar(message);
        }

        @Override
        default public void sendPlayerListHeader(Component header) {
            this.audience().sendPlayerListHeader(header);
        }

        @Override
        default public void sendPlayerListFooter(Component footer) {
            this.audience().sendPlayerListFooter(footer);
        }

        @Override
        default public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
            this.audience().sendPlayerListHeaderAndFooter(header, footer);
        }

        @Override
        default public <T> void sendTitlePart(TitlePart<T> part, T value) {
            this.audience().sendTitlePart(part, value);
        }

        @Override
        default public void clearTitle() {
            this.audience().clearTitle();
        }

        @Override
        default public void resetTitle() {
            this.audience().resetTitle();
        }

        @Override
        default public void showBossBar(BossBar bar) {
            this.audience().showBossBar(bar);
        }

        @Override
        default public void hideBossBar(BossBar bar) {
            this.audience().hideBossBar(bar);
        }

        @Override
        default public void playSound(Sound sound) {
            this.audience().playSound(sound);
        }

        @Override
        default public void playSound(Sound sound, double x, double y, double z) {
            this.audience().playSound(sound, x, y, z);
        }

        @Override
        default public void playSound(Sound sound, Sound.Emitter emitter) {
            this.audience().playSound(sound, emitter);
        }

        @Override
        default public void stopSound(SoundStop stop) {
            this.audience().stopSound(stop);
        }

        @Override
        default public void openBook(Book book) {
            this.audience().openBook(book);
        }

        @Override
        default public void sendResourcePacks(ResourcePackRequest request) {
            this.audience().sendResourcePacks(request.callback(Audiences.unwrapCallback(this, this.audience(), request.callback())));
        }

        @Override
        default public void removeResourcePacks(Iterable<UUID> ids) {
            this.audience().removeResourcePacks(ids);
        }

        @Override
        default public void removeResourcePacks(UUID id, UUID ... others) {
            this.audience().removeResourcePacks(id, others);
        }

        @Override
        default public void clearResourcePacks() {
            this.audience().clearResourcePacks();
        }

        @Override
        default public void showDialog(DialogLike dialog) {
            this.audience().showDialog(dialog);
        }

        @Override
        default public void closeDialog() {
            this.audience().closeDialog();
        }
    }
}

