/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.bossbar;

import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBarImpl;
import net.kyori.adventure.bossbar.BossBarViewer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.UnmodifiableView;

public sealed interface BossBar
permits BossBarImpl {
    public static final float MIN_PROGRESS = 0.0f;
    public static final float MAX_PROGRESS = 1.0f;

    public static BossBar bossBar(ComponentLike name, float progress, Color color, Overlay overlay) {
        BossBarImpl.checkProgress(progress);
        return BossBar.bossBar(name.asComponent(), progress, color, overlay);
    }

    public static BossBar bossBar(Component name, float progress, Color color, Overlay overlay) {
        BossBarImpl.checkProgress(progress);
        return new BossBarImpl(name, progress, color, overlay);
    }

    public static BossBar bossBar(ComponentLike name, float progress, Color color, Overlay overlay, Set<Flag> flags) {
        BossBarImpl.checkProgress(progress);
        return BossBar.bossBar(name.asComponent(), progress, color, overlay, flags);
    }

    public static BossBar bossBar(Component name, float progress, Color color, Overlay overlay, Set<Flag> flags) {
        BossBarImpl.checkProgress(progress);
        return new BossBarImpl(name, progress, color, overlay, flags);
    }

    public Component name();

    @Contract(value="_ -> this")
    default public BossBar name(ComponentLike name) {
        return this.name(name.asComponent());
    }

    @Contract(value="_ -> this")
    public BossBar name(Component var1);

    public float progress();

    @Contract(value="_ -> this")
    public BossBar progress(float var1);

    public Color color();

    @Contract(value="_ -> this")
    public BossBar color(Color var1);

    public Overlay overlay();

    @Contract(value="_ -> this")
    public BossBar overlay(Overlay var1);

    public @UnmodifiableView Set<Flag> flags();

    @Contract(value="_ -> this")
    public BossBar flags(Set<Flag> var1);

    public boolean hasFlag(Flag var1);

    @Contract(value="_ -> this")
    public BossBar addFlag(Flag var1);

    @Contract(value="_ -> this")
    public BossBar removeFlag(Flag var1);

    @Contract(value="_ -> this")
    public BossBar addFlags(Flag ... var1);

    @Contract(value="_ -> this")
    public BossBar removeFlags(Flag ... var1);

    @Contract(value="_ -> this")
    public BossBar addFlags(Iterable<Flag> var1);

    @Contract(value="_ -> this")
    public BossBar removeFlags(Iterable<Flag> var1);

    @Contract(value="_ -> this")
    public BossBar addListener(Listener var1);

    @Contract(value="_ -> this")
    public BossBar removeListener(Listener var1);

    public @UnmodifiableView Iterable<? extends BossBarViewer> viewers();

    default public BossBar addViewer(Audience viewer) {
        viewer.showBossBar(this);
        return this;
    }

    default public BossBar removeViewer(Audience viewer) {
        viewer.hideBossBar(this);
        return this;
    }

    public static enum Color {
        PINK("pink"),
        BLUE("blue"),
        RED("red"),
        GREEN("green"),
        YELLOW("yellow"),
        PURPLE("purple"),
        WHITE("white");

        public static final Index<String, Color> NAMES;
        private final String name;

        private Color(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Color.class, color -> color.name);
        }
    }

    public static enum Overlay {
        PROGRESS("progress"),
        NOTCHED_6("notched_6"),
        NOTCHED_10("notched_10"),
        NOTCHED_12("notched_12"),
        NOTCHED_20("notched_20");

        public static final Index<String, Overlay> NAMES;
        private final String name;

        private Overlay(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Overlay.class, overlay -> overlay.name);
        }
    }

    public static enum Flag {
        DARKEN_SCREEN("darken_screen"),
        PLAY_BOSS_MUSIC("play_boss_music"),
        CREATE_WORLD_FOG("create_world_fog");

        public static final Index<String, Flag> NAMES;
        private final String name;

        private Flag(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Flag.class, flag -> flag.name);
        }
    }

    public static interface Listener {
        default public void bossBarNameChanged(BossBar bar, Component oldName, Component newName) {
        }

        default public void bossBarProgressChanged(BossBar bar, float oldProgress, float newProgress) {
        }

        default public void bossBarColorChanged(BossBar bar, Color oldColor, Color newColor) {
        }

        default public void bossBarOverlayChanged(BossBar bar, Overlay oldOverlay, Overlay newOverlay) {
        }

        default public void bossBarFlagsChanged(BossBar bar, Set<Flag> flagsAdded, Set<Flag> flagsRemoved) {
        }
    }
}

