/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.chat;

import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import org.jspecify.annotations.Nullable;

record SignedMessageImpl(String message, Component unsignedContent, Instant timestamp, long salt) implements SignedMessage
{
    static final SecureRandom RANDOM = new SecureRandom();

    SignedMessageImpl(String message, Component unsignedContent) {
        this(message, unsignedContent, Instant.now(), RANDOM.nextLong());
    }

    @Override
    public @Nullable SignedMessage.Signature signature() {
        return null;
    }

    @Override
    public Identity identity() {
        return Identity.nil();
    }

    record SignatureImpl(byte[] bytes) implements SignedMessage.Signature
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            byte[] bytes1;
            if (!(o instanceof SignatureImpl)) return false;
            SignatureImpl signatureImpl = (SignatureImpl)o;
            try {
                byte[] byArray;
                bytes1 = byArray = signatureImpl.bytes();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return Objects.deepEquals(this.bytes, bytes1);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        @Override
        public String toString() {
            return "SignatureImpl{bytes=" + Arrays.toString(this.bytes) + "}";
        }
    }
}

