/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.identity;

import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.IdentityImpl;
import net.kyori.adventure.identity.NilIdentity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.pointer.Pointer;
import net.kyori.adventure.text.Component;

public sealed interface Identity
extends Identified
permits IdentityImpl, NilIdentity {
    public static final Pointer<String> NAME = Pointer.pointer(String.class, Key.key((String)"adventure", (String)"name"));
    public static final Pointer<UUID> UUID = Pointer.pointer(UUID.class, Key.key((String)"adventure", (String)"uuid"));
    public static final Pointer<Component> DISPLAY_NAME = Pointer.pointer(Component.class, Key.key((String)"adventure", (String)"display_name"));
    public static final Pointer<Locale> LOCALE = Pointer.pointer(Locale.class, Key.key((String)"adventure", (String)"locale"));

    public static Identity nil() {
        return NilIdentity.INSTANCE;
    }

    public static Identity identity(UUID uuid) {
        if (uuid.equals(NilIdentity.NIL_UUID)) {
            return NilIdentity.INSTANCE;
        }
        return new IdentityImpl(uuid);
    }

    public UUID uuid();

    @Override
    default public Identity identity() {
        return this;
    }
}

