/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.inventory.BookImpl;
import net.kyori.adventure.inventory.BookLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.Buildable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

public sealed interface Book
extends Buildable<Builder>,
BookLike
permits BookImpl {
    public static Book book(Component title, Component author, Collection<Component> pages) {
        return new BookImpl(title, author, new ArrayList<Component>(pages));
    }

    public static Book book(Component title, Component author, Component ... pages) {
        return Book.book(title, author, List.of(pages));
    }

    public static Builder builder() {
        return new BookImpl.BuilderImpl();
    }

    public Component title();

    @Contract(value="_ -> new", pure=true)
    public Book title(Component var1);

    public Component author();

    @Contract(value="_ -> new", pure=true)
    public Book author(Component var1);

    public @Unmodifiable List<Component> pages();

    @Contract(value="_ -> new", pure=true)
    default public Book pages(Component ... pages) {
        return this.pages(List.of(pages));
    }

    @Contract(value="_ -> new", pure=true)
    public Book pages(List<Component> var1);

    public static sealed interface Builder
    extends AbstractBuilder<Book>
    permits BookImpl.BuilderImpl {
        @Contract(value="_ -> this")
        public Builder title(Component var1);

        @Contract(value="_ -> this")
        public Builder author(Component var1);

        @Contract(value="_ -> this")
        public Builder addPage(Component var1);

        @Contract(value="_ -> this")
        public Builder pages(Component ... var1);

        @Contract(value="_ -> this")
        public Builder pages(Collection<Component> var1);
    }
}

