/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.pointer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.kyori.adventure.pointer.Pointer;
import net.kyori.adventure.pointer.Pointers;
import org.jspecify.annotations.Nullable;

record PointersImpl(Map<Pointer<?>, Supplier<?>> pointers) implements Pointers
{
    static final PointersImpl EMPTY = new PointersImpl(Map.of());

    PointersImpl(BuilderImpl pointers) {
        this(Map.copyOf(pointers.pointers));
    }

    @Override
    public <T> Optional<T> get(Pointer<T> pointer) {
        Objects.requireNonNull(pointer, "pointer");
        Supplier<?> supplier = this.pointers.get(pointer);
        return Optional.ofNullable(supplier).map(s -> s.get());
    }

    @Override
    public <T> boolean supports(Pointer<T> pointer) {
        Objects.requireNonNull(pointer, "pointer");
        return this.pointers.containsKey(pointer);
    }

    @Override
    public Pointers.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements Pointers.Builder {
        private final Map<Pointer<?>, Supplier<?>> pointers;

        BuilderImpl() {
            this.pointers = new HashMap();
        }

        BuilderImpl(PointersImpl pointers) {
            this.pointers = new HashMap(pointers.pointers);
        }

        @Override
        public <T> Pointers.Builder withDynamic(Pointer<T> pointer, Supplier<@Nullable T> value) {
            this.pointers.put(Objects.requireNonNull(pointer, "pointer"), Objects.requireNonNull(value, "value"));
            return this;
        }

        @Override
        public Pointers build() {
            return new PointersImpl(this);
        }
    }
}

