/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.sound;

import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.sound.SoundImpl;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.Range;

public sealed interface Sound
permits SoundImpl {
    public static Builder sound() {
        return new SoundImpl.BuilderImpl();
    }

    public static Builder sound(Sound existing) {
        return new SoundImpl.BuilderImpl(existing);
    }

    public static Sound sound(Consumer<Builder> configurer) {
        return (Sound)AbstractBuilder.configureAndBuild(Sound.sound(), configurer);
    }

    public static Sound sound(Key name, Source source, float volume, float pitch) {
        return (Sound)Sound.sound().type(name).source(source).volume(volume).pitch(pitch).build();
    }

    public static Sound sound(Type type, Source source, float volume, float pitch) {
        Objects.requireNonNull(type, "type");
        return Sound.sound(type.key(), source, volume, pitch);
    }

    public static Sound sound(Supplier<? extends Type> type, Source source, float volume, float pitch) {
        return (Sound)Sound.sound().type(type).source(source).volume(volume).pitch(pitch).build();
    }

    public static Sound sound(Key name, Source.Provider source, float volume, float pitch) {
        return Sound.sound(name, source.soundSource(), volume, pitch);
    }

    public static Sound sound(Type type, Source.Provider source, float volume, float pitch) {
        return Sound.sound(type, source.soundSource(), volume, pitch);
    }

    public static Sound sound(Supplier<? extends Type> type, Source.Provider source, float volume, float pitch) {
        return Sound.sound(type, source.soundSource(), volume, pitch);
    }

    public Key name();

    public Source source();

    public float volume();

    public float pitch();

    public OptionalLong seed();

    public SoundStop asStop();

    public static sealed interface Builder
    extends AbstractBuilder<Sound>
    permits SoundImpl.BuilderImpl {
        public Builder type(Key var1);

        public Builder type(Type var1);

        public Builder type(Supplier<? extends Type> var1);

        public Builder source(Source var1);

        public Builder source(Source.Provider var1);

        public Builder volume(@Range(from=0L, to=0x7FFFFFFFL) float var1);

        public Builder pitch(@Range(from=-1L, to=1L) float var1);

        public Builder seed(long var1);

        public Builder seed(OptionalLong var1);
    }

    public static enum Source {
        MASTER("master"),
        MUSIC("music"),
        RECORD("record"),
        WEATHER("weather"),
        BLOCK("block"),
        HOSTILE("hostile"),
        NEUTRAL("neutral"),
        PLAYER("player"),
        AMBIENT("ambient"),
        VOICE("voice"),
        UI("ui");

        public static final Index<String, Source> NAMES;
        private final String name;

        private Source(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Source.class, source -> source.name);
        }

        public static interface Provider {
            public Source soundSource();
        }
    }

    public static interface Type
    extends Keyed {
        public Key key();
    }

    public static interface Emitter {
        public static Emitter self() {
            return SoundImpl.EMITTER_SELF;
        }
    }
}

