/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.regex.Matcher;
import net.kyori.adventure.text.BlockNBTComponentImpl;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ScopedComponent;
import org.jetbrains.annotations.Contract;

public sealed interface BlockNBTComponent
extends NBTComponent<BlockNBTComponent>,
ScopedComponent<BlockNBTComponent>
permits BlockNBTComponentImpl {
    public Pos pos();

    @Contract(pure=true)
    public BlockNBTComponent pos(Pos var1);

    @Contract(pure=true)
    default public BlockNBTComponent localPos(double left, double up, double forwards) {
        return this.pos(LocalPos.localPos(left, up, forwards));
    }

    @Contract(pure=true)
    default public BlockNBTComponent worldPos(WorldPos.Coordinate x, WorldPos.Coordinate y, WorldPos.Coordinate z) {
        return this.pos(WorldPos.worldPos(x, y, z));
    }

    @Contract(pure=true)
    default public BlockNBTComponent absoluteWorldPos(int x, int y, int z) {
        return this.worldPos(WorldPos.Coordinate.absolute(x), WorldPos.Coordinate.absolute(y), WorldPos.Coordinate.absolute(z));
    }

    @Contract(pure=true)
    default public BlockNBTComponent relativeWorldPos(int x, int y, int z) {
        return this.worldPos(WorldPos.Coordinate.relative(x), WorldPos.Coordinate.relative(y), WorldPos.Coordinate.relative(z));
    }

    @Override
    public Builder toBuilder();

    public static interface LocalPos
    extends Pos {
        public static LocalPos localPos(double left, double up, double forwards) {
            return new BlockNBTComponentImpl.LocalPosImpl(left, up, forwards);
        }

        public double left();

        public double up();

        public double forwards();
    }

    public static interface Pos {
        public static Pos fromString(String input) throws IllegalArgumentException {
            Matcher localMatch = BlockNBTComponentImpl.Tokens.LOCAL_PATTERN.matcher(input);
            if (localMatch.matches()) {
                return LocalPos.localPos(Double.parseDouble(localMatch.group(1)), Double.parseDouble(localMatch.group(3)), Double.parseDouble(localMatch.group(5)));
            }
            Matcher worldMatch = BlockNBTComponentImpl.Tokens.WORLD_PATTERN.matcher(input);
            if (worldMatch.matches()) {
                return WorldPos.worldPos(BlockNBTComponentImpl.Tokens.deserializeCoordinate(worldMatch.group(1), worldMatch.group(2)), BlockNBTComponentImpl.Tokens.deserializeCoordinate(worldMatch.group(3), worldMatch.group(4)), BlockNBTComponentImpl.Tokens.deserializeCoordinate(worldMatch.group(5), worldMatch.group(6)));
            }
            throw new IllegalArgumentException("Cannot convert position specification '" + input + "' into a position");
        }

        public String asString();
    }

    public static interface WorldPos
    extends Pos {
        public static WorldPos worldPos(Coordinate x, Coordinate y, Coordinate z) {
            return new BlockNBTComponentImpl.WorldPosImpl(x, y, z);
        }

        public Coordinate x();

        public Coordinate y();

        public Coordinate z();

        public static interface Coordinate {
            public static Coordinate absolute(int value) {
                return Coordinate.coordinate(value, Type.ABSOLUTE);
            }

            public static Coordinate relative(int value) {
                return Coordinate.coordinate(value, Type.RELATIVE);
            }

            public static Coordinate coordinate(int value, Type type) {
                return new BlockNBTComponentImpl.WorldPosImpl.CoordinateImpl(value, type);
            }

            public int value();

            public Type type();

            public static enum Type {
                ABSOLUTE,
                RELATIVE;

            }
        }
    }

    public static sealed interface Builder
    extends NBTComponentBuilder<BlockNBTComponent, Builder>
    permits BlockNBTComponentImpl.BuilderImpl {
        @Contract(value="_ -> this")
        public Builder pos(Pos var1);

        @Contract(value="_, _, _ -> this")
        default public Builder localPos(double left, double up, double forwards) {
            return this.pos(LocalPos.localPos(left, up, forwards));
        }

        @Contract(value="_, _, _ -> this")
        default public Builder worldPos(WorldPos.Coordinate x, WorldPos.Coordinate y, WorldPos.Coordinate z) {
            return this.pos(WorldPos.worldPos(x, y, z));
        }

        @Contract(value="_, _, _ -> this")
        default public Builder absoluteWorldPos(int x, int y, int z) {
            return this.worldPos(WorldPos.Coordinate.absolute(x), WorldPos.Coordinate.absolute(y), WorldPos.Coordinate.absolute(z));
        }

        @Contract(value="_, _, _ -> this")
        default public Builder relativeWorldPos(int x, int y, int z) {
            return this.worldPos(WorldPos.Coordinate.relative(x), WorldPos.Coordinate.relative(y), WorldPos.Coordinate.relative(z));
        }
    }
}

