/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.kyori.adventure.text.AbstractNBTComponentBuilder;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.Style;
import org.jspecify.annotations.Nullable;

record BlockNBTComponentImpl(List<Component> children, Style style, String nbtPath, boolean interpret, @Nullable Component separator, BlockNBTComponent.Pos pos) implements BlockNBTComponent
{
    static BlockNBTComponent create(List<? extends ComponentLike> children, Style style, String nbtPath, boolean interpret, @Nullable ComponentLike separator, BlockNBTComponent.Pos pos) {
        return new BlockNBTComponentImpl(ComponentLike.asComponents(children, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(nbtPath, "nbtPath"), interpret, ComponentLike.unbox(separator), Objects.requireNonNull(pos, "pos"));
    }

    @Override
    public BlockNBTComponent nbtPath(String nbtPath) {
        if (Objects.equals(this.nbtPath, nbtPath)) {
            return this;
        }
        return BlockNBTComponentImpl.create(this.children, this.style, nbtPath, this.interpret, this.separator, this.pos);
    }

    @Override
    public BlockNBTComponent interpret(boolean interpret) {
        if (this.interpret == interpret) {
            return this;
        }
        return BlockNBTComponentImpl.create(this.children, this.style, this.nbtPath, interpret, this.separator, this.pos);
    }

    @Override
    public BlockNBTComponent separator(@Nullable ComponentLike separator) {
        return BlockNBTComponentImpl.create(this.children, this.style, this.nbtPath, this.interpret, separator, this.pos);
    }

    @Override
    public BlockNBTComponent pos(BlockNBTComponent.Pos pos) {
        return BlockNBTComponentImpl.create(this.children, this.style, this.nbtPath, this.interpret, this.separator, pos);
    }

    @Override
    public BlockNBTComponent children(List<? extends ComponentLike> children) {
        return BlockNBTComponentImpl.create(children, this.style, this.nbtPath, this.interpret, this.separator, this.pos);
    }

    @Override
    public BlockNBTComponent style(Style style) {
        return BlockNBTComponentImpl.create(this.children, style, this.nbtPath, this.interpret, this.separator, this.pos);
    }

    @Override
    public BlockNBTComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractNBTComponentBuilder<BlockNBTComponent, BlockNBTComponent.Builder>
    implements BlockNBTComponent.Builder {
        private @Nullable BlockNBTComponent.Pos pos;

        BuilderImpl() {
        }

        BuilderImpl(BlockNBTComponent component) {
            super(component);
            this.pos = component.pos();
        }

        @Override
        public BlockNBTComponent.Builder pos(BlockNBTComponent.Pos pos) {
            this.pos = Objects.requireNonNull(pos, "pos");
            return this;
        }

        @Override
        public BlockNBTComponent build() {
            if (this.nbtPath == null) {
                throw new IllegalStateException("nbt path must be set");
            }
            if (this.pos == null) {
                throw new IllegalStateException("pos must be set");
            }
            return BlockNBTComponentImpl.create(this.children, this.buildStyle(), this.nbtPath, this.interpret, this.separator, this.pos);
        }
    }

    static final class Tokens {
        static final Pattern LOCAL_PATTERN = Pattern.compile("^\\^(-?\\d+(\\.\\d+)?) \\^(-?\\d+(\\.\\d+)?) \\^(-?\\d+(\\.\\d+)?)$");
        static final Pattern WORLD_PATTERN = Pattern.compile("^(~?)(-?\\d+) (~?)(-?\\d+) (~?)(-?\\d+)$");
        static final String LOCAL_SYMBOL = "^";
        static final String RELATIVE_SYMBOL = "~";
        static final String ABSOLUTE_SYMBOL = "";

        private Tokens() {
        }

        static BlockNBTComponent.WorldPos.Coordinate deserializeCoordinate(String prefix, String value) {
            int i = Integer.parseInt(value);
            if (prefix.equals(ABSOLUTE_SYMBOL)) {
                return BlockNBTComponent.WorldPos.Coordinate.absolute(i);
            }
            if (prefix.equals(RELATIVE_SYMBOL)) {
                return BlockNBTComponent.WorldPos.Coordinate.relative(i);
            }
            throw new AssertionError();
        }

        static String serializeLocal(double value) {
            return LOCAL_SYMBOL + value;
        }

        static String serializeCoordinate(BlockNBTComponent.WorldPos.Coordinate coordinate) {
            return (coordinate.type() == BlockNBTComponent.WorldPos.Coordinate.Type.RELATIVE ? RELATIVE_SYMBOL : ABSOLUTE_SYMBOL) + coordinate.value();
        }
    }

    record WorldPosImpl(BlockNBTComponent.WorldPos.Coordinate x, BlockNBTComponent.WorldPos.Coordinate y, BlockNBTComponent.WorldPos.Coordinate z) implements BlockNBTComponent.WorldPos
    {
        WorldPosImpl(BlockNBTComponent.WorldPos.Coordinate x, BlockNBTComponent.WorldPos.Coordinate y, BlockNBTComponent.WorldPos.Coordinate z) {
            this.x = Objects.requireNonNull(x, "x");
            this.y = Objects.requireNonNull(y, "y");
            this.z = Objects.requireNonNull(z, "z");
        }

        @Override
        public String toString() {
            return this.x.toString() + " " + this.y.toString() + " " + this.z.toString();
        }

        @Override
        public String asString() {
            return Tokens.serializeCoordinate(this.x()) + " " + Tokens.serializeCoordinate(this.y()) + " " + Tokens.serializeCoordinate(this.z());
        }

        record CoordinateImpl(int value, BlockNBTComponent.WorldPos.Coordinate.Type type) implements BlockNBTComponent.WorldPos.Coordinate
        {
            CoordinateImpl(int value, BlockNBTComponent.WorldPos.Coordinate.Type type) {
                this.value = value;
                this.type = Objects.requireNonNull(type, "type");
            }

            @Override
            public String toString() {
                return (this.type == BlockNBTComponent.WorldPos.Coordinate.Type.RELATIVE ? "~" : "") + this.value;
            }
        }
    }

    record LocalPosImpl(double left, double up, double forwards) implements BlockNBTComponent.LocalPos
    {
        @Override
        public String toString() {
            return String.format("^%f ^%f ^%f", this.left, this.up, this.forwards);
        }

        @Override
        public String asString() {
            return Tokens.serializeLocal(this.left) + " " + Tokens.serializeLocal(this.up) + " " + Tokens.serializeLocal(this.forwards);
        }
    }
}

