/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.AbstractComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilderApplicable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.MutableStyleSetter;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public sealed interface ComponentBuilder<C extends Component, B extends ComponentBuilder<C, B>>
extends AbstractBuilder<C>,
ComponentBuilderApplicable,
ComponentLike,
MutableStyleSetter<B>
permits AbstractComponentBuilder, KeybindComponent.Builder, NBTComponentBuilder, ObjectComponent.Builder, ScoreComponent.Builder, SelectorComponent.Builder, TextComponent.Builder, TranslatableComponent.Builder {
    @Contract(value="_ -> this")
    public B append(Component var1);

    @Contract(value="_ -> this")
    default public B append(ComponentLike component) {
        return this.append(component.asComponent());
    }

    @Contract(value="_ -> this")
    default public B append(ComponentBuilder<?, ?> builder) {
        return this.append((Component)builder.build());
    }

    @Contract(value="_ -> this")
    public B append(Component ... var1);

    @Contract(value="_ -> this")
    public B append(ComponentLike ... var1);

    @Contract(value="_ -> this")
    public B append(Iterable<? extends ComponentLike> var1);

    default public B appendNewline() {
        return this.append((Component)Component.newline());
    }

    default public B appendSpace() {
        return this.append((Component)Component.space());
    }

    @Contract(value="_ -> this")
    default public B apply(Consumer<? super ComponentBuilder<?, ?>> consumer) {
        consumer.accept(this);
        return (B)this;
    }

    @Contract(value="_ -> this")
    public B applyDeep(Consumer<? super ComponentBuilder<?, ?>> var1);

    @Contract(value="_ -> this")
    public B mapChildren(Function<Component, ? extends Component> var1);

    @Contract(value="_ -> this")
    public B mapChildrenDeep(Function<Component, ? extends Component> var1);

    public List<Component> children();

    @Contract(value="_ -> this")
    public B style(Style var1);

    @Contract(value="_ -> this")
    public B style(Consumer<Style.Builder> var1);

    @Override
    @Contract(value="_ -> this")
    public B font(@Nullable Key var1);

    @Override
    @Contract(value="_ -> this")
    public B color(@Nullable TextColor var1);

    @Override
    @Contract(value="_ -> this")
    public B colorIfAbsent(@Nullable TextColor var1);

    @Override
    @Contract(value="_, _ -> this")
    default public B decorations(Set<TextDecoration> decorations, boolean flag) {
        return (B)((ComponentBuilder)MutableStyleSetter.super.decorations((Set)decorations, flag));
    }

    @Override
    @Contract(value="_ -> this")
    default public B decorate(TextDecoration decoration) {
        return (B)this.decoration(decoration, TextDecoration.State.TRUE);
    }

    @Override
    @Contract(value="_ -> this")
    default public B decorate(TextDecoration ... decorations) {
        return (B)((ComponentBuilder)MutableStyleSetter.super.decorate(decorations));
    }

    @Override
    @Contract(value="_, _ -> this")
    default public B decoration(TextDecoration decoration, boolean flag) {
        return (B)this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    @Override
    @Contract(value="_ -> this")
    default public B decorations(Map<TextDecoration, TextDecoration.State> decorations) {
        return (B)((ComponentBuilder)MutableStyleSetter.super.decorations((Map)decorations));
    }

    @Override
    @Contract(value="_, _ -> this")
    public B decoration(TextDecoration var1, TextDecoration.State var2);

    @Override
    @Contract(value="_, _ -> this")
    public B decorationIfAbsent(TextDecoration var1, TextDecoration.State var2);

    @Override
    @Contract(value="_ -> this")
    public B clickEvent(@Nullable ClickEvent<?> var1);

    @Override
    @Contract(value="_ -> this")
    public B hoverEvent(@Nullable HoverEventSource<?> var1);

    @Override
    @Contract(value="_ -> this")
    public B insertion(@Nullable String var1);

    @Contract(value="_ -> this")
    default public B mergeStyle(Component that) {
        return this.mergeStyle(that, Style.Merge.all());
    }

    @Contract(value="_, _ -> this")
    default public B mergeStyle(Component that, Style.Merge ... merges) {
        return this.mergeStyle(that, Style.Merge.merges(merges));
    }

    @Contract(value="_, _ -> this")
    public B mergeStyle(Component var1, Set<Style.Merge> var2);

    public B resetStyle();

    @Override
    public C build();

    @Contract(value="_ -> this")
    default public B applicableApply(ComponentBuilderApplicable applicable) {
        applicable.componentBuilderApply(this);
        return (B)this;
    }

    @Override
    default public void componentBuilderApply(ComponentBuilder<?, ?> component) {
        component.append(this);
    }

    @Override
    default public Component asComponent() {
        return this.build();
    }
}

