/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfigurationImpl;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public sealed interface JoinConfiguration
permits JoinConfigurationImpl {
    public static Builder builder() {
        return new JoinConfigurationImpl.BuilderImpl();
    }

    public static JoinConfiguration noSeparators() {
        return JoinConfigurationImpl.NULL;
    }

    public static JoinConfiguration newlines() {
        return JoinConfigurationImpl.STANDARD_NEW_LINES;
    }

    public static JoinConfiguration spaces() {
        return JoinConfigurationImpl.STANDARD_SPACES;
    }

    public static JoinConfiguration commas(boolean spaces) {
        return spaces ? JoinConfigurationImpl.STANDARD_COMMA_SPACE_SEPARATED : JoinConfigurationImpl.STANDARD_COMMA_SEPARATED;
    }

    public static JoinConfiguration arrayLike() {
        return JoinConfigurationImpl.STANDARD_ARRAY_LIKE;
    }

    public static JoinConfiguration separator(@Nullable ComponentLike separator) {
        if (separator == null) {
            return JoinConfigurationImpl.NULL;
        }
        return (JoinConfiguration)JoinConfiguration.builder().separator(separator).build();
    }

    public static JoinConfiguration separators(@Nullable ComponentLike separator, @Nullable ComponentLike lastSeparator) {
        if (separator == null && lastSeparator == null) {
            return JoinConfigurationImpl.NULL;
        }
        return (JoinConfiguration)JoinConfiguration.builder().separator(separator).lastSeparator(lastSeparator).build();
    }

    public @Nullable Component prefix();

    public @Nullable Component suffix();

    public @Nullable Component separator();

    public @Nullable Component lastSeparator();

    public @Nullable Component lastSeparatorIfSerial();

    public Function<ComponentLike, Component> convertor();

    public Predicate<ComponentLike> predicate();

    public Style parentStyle();

    public static sealed interface Builder
    extends AbstractBuilder<JoinConfiguration>
    permits JoinConfigurationImpl.BuilderImpl {
        @Contract(value="_ -> this")
        public Builder prefix(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        public Builder suffix(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        public Builder separator(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        public Builder lastSeparator(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        public Builder lastSeparatorIfSerial(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        public Builder convertor(Function<ComponentLike, Component> var1);

        @Contract(value="_ -> this")
        public Builder predicate(Predicate<ComponentLike> var1);

        @Contract(value="_ -> this")
        public Builder parentStyle(Style var1);
    }
}

