/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilderApplicable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponentImpl;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;

public final class LinearComponents {
    private LinearComponents() {
    }

    public static Component linear(ComponentBuilderApplicable ... applicables) {
        int length = applicables.length;
        if (length == 0) {
            return Component.empty();
        }
        if (length == 1) {
            ComponentBuilderApplicable ap0 = applicables[0];
            if (ap0 instanceof ComponentLike) {
                ComponentLike cl = (ComponentLike)((Object)ap0);
                return cl.asComponent();
            }
            throw LinearComponents.nothingComponentLike();
        }
        TextComponentImpl.BuilderImpl builder = new TextComponentImpl.BuilderImpl();
        Style.Builder style = null;
        for (ComponentBuilderApplicable applicable : applicables) {
            if (applicable instanceof StyleBuilderApplicable) {
                StyleBuilderApplicable sba = (StyleBuilderApplicable)applicable;
                if (style == null) {
                    style = Style.style();
                }
                style.apply(sba);
                continue;
            }
            if (style != null && applicable instanceof ComponentLike) {
                ComponentLike cl = (ComponentLike)((Object)applicable);
                builder.applicableApply(cl.asComponent().style(style));
                continue;
            }
            builder.applicableApply(applicable);
        }
        int size = builder.children.size();
        if (size == 0) {
            throw LinearComponents.nothingComponentLike();
        }
        if (size == 1 && !builder.hasStyle()) {
            return (Component)builder.children.getFirst();
        }
        return builder.build();
    }

    private static IllegalStateException nothingComponentLike() {
        return new IllegalStateException("Cannot build component linearly - nothing component-like was given");
    }
}

