/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.AbstractComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.format.Style;
import org.jspecify.annotations.Nullable;

record ScoreComponentImpl(List<Component> children, Style style, String name, String objective, @Nullable String value) implements ScoreComponent
{
    static ScoreComponent create(List<? extends ComponentLike> children, Style style, String name, String objective, @Nullable String value) {
        return new ScoreComponentImpl(ComponentLike.asComponents(children, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(name, "name"), Objects.requireNonNull(objective, "objective"), value);
    }

    @Override
    public ScoreComponent name(String name) {
        if (Objects.equals(this.name, name)) {
            return this;
        }
        return ScoreComponentImpl.create(this.children, this.style, name, this.objective, this.value);
    }

    @Override
    public ScoreComponent objective(String objective) {
        if (Objects.equals(this.objective, objective)) {
            return this;
        }
        return ScoreComponentImpl.create(this.children, this.style, this.name, objective, this.value);
    }

    @Override
    public ScoreComponent value(@Nullable String value) {
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return ScoreComponentImpl.create(this.children, this.style, this.name, this.objective, value);
    }

    @Override
    public ScoreComponent children(List<? extends ComponentLike> children) {
        return ScoreComponentImpl.create(children, this.style, this.name, this.objective, this.value);
    }

    @Override
    public ScoreComponent style(Style style) {
        return ScoreComponentImpl.create(this.children, style, this.name, this.objective, this.value);
    }

    @Override
    public ScoreComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<ScoreComponent, ScoreComponent.Builder>
    implements ScoreComponent.Builder {
        private @Nullable String name;
        private @Nullable String objective;
        private @Nullable String value;

        BuilderImpl() {
        }

        BuilderImpl(ScoreComponent component) {
            super(component);
            this.name = component.name();
            this.objective = component.objective();
        }

        @Override
        public ScoreComponent.Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @Override
        public ScoreComponent.Builder objective(String objective) {
            this.objective = Objects.requireNonNull(objective, "objective");
            return this;
        }

        @Override
        public ScoreComponent.Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        @Override
        public ScoreComponent build() {
            if (this.name == null) {
                throw new IllegalStateException("name must be set");
            }
            if (this.objective == null) {
                throw new IllegalStateException("objective must be set");
            }
            return ScoreComponentImpl.create(this.children, this.buildStyle(), this.name, this.objective, this.value);
        }
    }
}

