/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.PatternReplacementResult;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.TextReplacementRenderer;
import org.jspecify.annotations.Nullable;

record TextReplacementConfigImpl(Pattern matchPattern, BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement, TextReplacementConfig.Condition continuer, boolean replaceInsideHoverEvents) implements TextReplacementConfig
{
    TextReplacementRenderer.State createState() {
        return new TextReplacementRenderer.State(this.matchPattern, this.replacement, this.continuer, this.replaceInsideHoverEvents);
    }

    static final class Builder
    implements TextReplacementConfig.Builder {
        @Nullable Pattern matchPattern;
        @Nullable BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement;
        TextReplacementConfig.Condition continuer = (matchResult, index, replacement) -> PatternReplacementResult.REPLACE;
        boolean replaceInsideHoverEvents = true;

        Builder() {
        }

        @Override
        public Builder match(Pattern pattern) {
            this.matchPattern = Objects.requireNonNull(pattern, "pattern");
            return this;
        }

        @Override
        public Builder condition(TextReplacementConfig.Condition condition) {
            this.continuer = Objects.requireNonNull(condition, "continuation");
            return this;
        }

        @Override
        public Builder replacement(BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement) {
            this.replacement = Objects.requireNonNull(replacement, "replacement");
            return this;
        }

        @Override
        public TextReplacementConfig.Builder replaceInsideHoverEvents(boolean replace) {
            this.replaceInsideHoverEvents = replace;
            return this;
        }

        @Override
        public TextReplacementConfig build() {
            if (this.matchPattern == null) {
                throw new IllegalStateException("A pattern must be provided to match against");
            }
            if (this.replacement == null) {
                throw new IllegalStateException("A replacement action must be provided");
            }
            return new TextReplacementConfigImpl(this.matchPattern, this.replacement, this.continuer, this.replaceInsideHoverEvents);
        }
    }
}

