/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.text.event.ClickCallbackInternals;
import net.kyori.adventure.text.event.ClickCallbackOptionsImpl;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.util.PlatformAPI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface ClickCallback<T extends Audience> {
    public static final Duration DEFAULT_LIFETIME = Duration.ofHours(12L);
    public static final int UNLIMITED_USES = -1;

    @CheckReturnValue
    @Contract(pure=true)
    public static <W extends Audience, N extends W> ClickCallback<W> widen(ClickCallback<N> original, Class<N> type, @Nullable Consumer<? super Audience> otherwise) {
        return audience -> {
            if (type.isInstance(audience)) {
                original.accept((Audience)type.cast(audience));
            } else if (otherwise != null) {
                otherwise.accept(audience);
            }
        };
    }

    @CheckReturnValue
    @Contract(pure=true)
    public static <W extends Audience, N extends W> ClickCallback<W> widen(ClickCallback<N> original, Class<N> type) {
        return ClickCallback.widen(original, type, null);
    }

    public void accept(T var1);

    @CheckReturnValue
    @Contract(pure=true)
    default public ClickCallback<T> filter(Predicate<T> filter) {
        return this.filter(filter, null);
    }

    @CheckReturnValue
    @Contract(pure=true)
    default public ClickCallback<T> filter(Predicate<T> filter, @Nullable Consumer<? super Audience> otherwise) {
        return audience -> {
            if (filter.test(audience)) {
                this.accept(audience);
            } else if (otherwise != null) {
                otherwise.accept(audience);
            }
        };
    }

    @CheckReturnValue
    @Contract(pure=true)
    default public ClickCallback<T> requiringPermission(String permission) {
        return this.requiringPermission(permission, null);
    }

    @CheckReturnValue
    @Contract(pure=true)
    default public ClickCallback<T> requiringPermission(String permission, @Nullable Consumer<? super Audience> otherwise) {
        return this.filter(audience -> audience.getOrDefault(PermissionChecker.POINTER, ClickCallbackInternals.ALWAYS_FALSE).test(permission), otherwise);
    }

    @PlatformAPI
    @ApiStatus.Internal
    public static interface Provider {
        public ClickEvent<?> create(ClickCallback<Audience> var1, Options var2);
    }

    public static sealed interface Options
    permits ClickCallbackOptionsImpl {
        public static Builder builder() {
            return new ClickCallbackOptionsImpl.BuilderImpl();
        }

        public static Builder builder(Options existing) {
            return new ClickCallbackOptionsImpl.BuilderImpl(existing);
        }

        public int uses();

        public Duration lifetime();

        public static sealed interface Builder
        extends AbstractBuilder<Options>
        permits ClickCallbackOptionsImpl.BuilderImpl {
            public Builder uses(int var1);

            public Builder lifetime(TemporalAmount var1);
        }
    }
}

