/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import net.kyori.adventure.text.event.ClickCallback;

record ClickCallbackOptionsImpl(int uses, Duration lifetime) implements ClickCallback.Options
{
    static final ClickCallback.Options DEFAULT = new BuilderImpl().build();

    static final class BuilderImpl
    implements ClickCallback.Options.Builder {
        private static final int DEFAULT_USES = 1;
        private int uses;
        private Duration lifetime;

        BuilderImpl() {
            this.uses = 1;
            this.lifetime = ClickCallback.DEFAULT_LIFETIME;
        }

        BuilderImpl(ClickCallback.Options existing) {
            this.uses = existing.uses();
            this.lifetime = existing.lifetime();
        }

        @Override
        public ClickCallback.Options build() {
            return new ClickCallbackOptionsImpl(this.uses, this.lifetime);
        }

        @Override
        public ClickCallback.Options.Builder uses(int uses) {
            this.uses = uses;
            return this;
        }

        @Override
        public ClickCallback.Options.Builder lifetime(TemporalAmount lifetime) {
            Duration duration;
            this.lifetime = lifetime instanceof Duration ? (duration = (Duration)lifetime) : Duration.from(Objects.requireNonNull(lifetime, "lifetime"));
            return this;
        }
    }
}

