/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.DataComponentValueConverterRegistry;
import net.kyori.adventure.text.event.HoverEventRenderers;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

public final class HoverEvent<V>
implements HoverEventSource<V>,
StyleBuilderApplicable {
    private final Action<V> action;
    private final V value;

    public static HoverEvent<Component> showText(ComponentLike text) {
        return HoverEvent.showText(text.asComponent());
    }

    public static HoverEvent<Component> showText(Component text) {
        return new HoverEvent<Component>(Action.SHOW_TEXT, text);
    }

    public static HoverEvent<ShowItem> showItem(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
        return HoverEvent.showItem((Keyed)item, count, Map.of());
    }

    public static HoverEvent<ShowItem> showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
        return HoverEvent.showItem(item, count, Map.of());
    }

    @ApiStatus.Obsolete
    public static HoverEvent<ShowItem> showItem(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count, @Nullable BinaryTagHolder nbt) {
        return HoverEvent.showItem(ShowItem.showItem(item, count, nbt));
    }

    @ApiStatus.Obsolete
    public static HoverEvent<ShowItem> showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count, @Nullable BinaryTagHolder nbt) {
        return HoverEvent.showItem(ShowItem.showItem(item, count, nbt));
    }

    public static HoverEvent<ShowItem> showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count, Map<Key, ? extends DataComponentValue> dataComponents) {
        return HoverEvent.showItem(ShowItem.showItem(item, count, dataComponents));
    }

    public static HoverEvent<ShowItem> showItem(ShowItem item) {
        return new HoverEvent<ShowItem>(Action.SHOW_ITEM, item);
    }

    public static HoverEvent<ShowEntity> showEntity(Key type, UUID id) {
        return HoverEvent.showEntity(type, id, null);
    }

    public static HoverEvent<ShowEntity> showEntity(Keyed type, UUID id) {
        return HoverEvent.showEntity(type, id, null);
    }

    public static HoverEvent<ShowEntity> showEntity(Key type, UUID id, @Nullable Component name) {
        return HoverEvent.showEntity(ShowEntity.showEntity(type, id, name));
    }

    public static HoverEvent<ShowEntity> showEntity(Keyed type, UUID id, @Nullable Component name) {
        return HoverEvent.showEntity(ShowEntity.showEntity(type, id, name));
    }

    public static HoverEvent<ShowEntity> showEntity(ShowEntity entity) {
        return new HoverEvent<ShowEntity>(Action.SHOW_ENTITY, entity);
    }

    @ApiStatus.Obsolete
    public static HoverEvent<String> showAchievement(String value) {
        return new HoverEvent<String>(Action.SHOW_ACHIEVEMENT, value);
    }

    public static <V> HoverEvent<V> hoverEvent(Action<V> action, V value) {
        return new HoverEvent<V>(action, value);
    }

    private HoverEvent(Action<V> action, V value) {
        this.action = Objects.requireNonNull(action, "action");
        this.value = Objects.requireNonNull(value, "value");
    }

    public Action<V> action() {
        return this.action;
    }

    public V value() {
        return this.value;
    }

    @Contract(pure=true)
    public HoverEvent<V> value(V value) {
        return new HoverEvent<V>(this.action, value);
    }

    public <C> HoverEvent<V> withRenderedValue(ComponentRenderer<C> renderer, C context) {
        V oldValue = this.value;
        V newValue = this.action.renderer().render(renderer, context, oldValue);
        if (newValue != oldValue) {
            return new HoverEvent<V>(this.action, newValue);
        }
        return this;
    }

    @Override
    public HoverEvent<V> asHoverEvent() {
        return this;
    }

    @Override
    public HoverEvent<V> asHoverEvent(UnaryOperator<V> op) {
        if (op == UnaryOperator.identity()) {
            return this;
        }
        return new HoverEvent<V>(this.action, op.apply(this.value));
    }

    @Override
    public void styleApply(Style.Builder style) {
        style.hoverEvent((HoverEventSource)this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HoverEvent)) {
            return false;
        }
        HoverEvent that = (HoverEvent)o;
        return this.action.equals(that.action) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "HoverEvent{action=" + String.valueOf(this.action) + ", value=" + String.valueOf(this.value) + "}";
    }

    public static final class Action<V> {
        public static final Action<Component> SHOW_TEXT = new Action<Component>("show_text", Component.class, true, HoverEventRenderers.SHOW_TEXT);
        public static final Action<ShowItem> SHOW_ITEM = new Action<ShowItem>("show_item", ShowItem.class, true, HoverEventRenderers.SHOW_ITEM);
        public static final Action<ShowEntity> SHOW_ENTITY = new Action<ShowEntity>("show_entity", ShowEntity.class, true, HoverEventRenderers.SHOW_ENTITY);
        @ApiStatus.Obsolete
        public static final Action<String> SHOW_ACHIEVEMENT = new Action<String>("show_achievement", String.class, true, HoverEventRenderers.SHOW_ACHIEVEMENT);
        public static final Index<String, Action<?>> NAMES = Index.create(Action::toString, SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY, SHOW_ACHIEVEMENT);
        private final String name;
        private final Class<V> type;
        private final boolean readable;
        private final Renderer<V> renderer;

        private Action(String name, Class<V> type, boolean readable, Renderer<V> renderer) {
            this.name = name;
            this.type = type;
            this.readable = readable;
            this.renderer = renderer;
        }

        public String name() {
            return this.name;
        }

        public Class<V> type() {
            return this.type;
        }

        public boolean readable() {
            return this.readable;
        }

        public Renderer<V> renderer() {
            return this.renderer;
        }

        public String toString() {
            return this.name;
        }

        public static sealed interface Renderer<V>
        permits HoverEventRenderers.ShowAchievement, HoverEventRenderers.ShowEntity, HoverEventRenderers.ShowItem, HoverEventRenderers.ShowText {
            public <C> V render(ComponentRenderer<C> var1, C var2, V var3);
        }
    }

    public static final class ShowItem {
        private final Key item;
        private final int count;
        private final @Nullable BinaryTagHolder nbt;
        private final Map<Key, DataComponentValue> dataComponents;

        public static ShowItem showItem(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
            return ShowItem.showItem((Keyed)item, count, Map.of());
        }

        public static ShowItem showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
            return ShowItem.showItem(item, count, Map.of());
        }

        @ApiStatus.Obsolete
        public static ShowItem showItem(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count, @Nullable BinaryTagHolder nbt) {
            return new ShowItem(Objects.requireNonNull(item, "item"), count, nbt, Map.of());
        }

        @ApiStatus.Obsolete
        public static ShowItem showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count, @Nullable BinaryTagHolder nbt) {
            return new ShowItem(Objects.requireNonNull(item, "item").key(), count, nbt, Map.of());
        }

        public static ShowItem showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count, Map<Key, ? extends DataComponentValue> dataComponents) {
            return new ShowItem(Objects.requireNonNull(item, "item").key(), count, null, Map.copyOf(Objects.requireNonNull(dataComponents, "dataComponents")));
        }

        private ShowItem(Key item, int count, @Nullable BinaryTagHolder nbt, Map<Key, DataComponentValue> dataComponents) {
            this.item = item;
            this.count = count;
            this.nbt = nbt;
            this.dataComponents = dataComponents;
        }

        public Key item() {
            return this.item;
        }

        public ShowItem item(Key item) {
            if (Objects.requireNonNull(item, "item").equals((Object)this.item)) {
                return this;
            }
            return new ShowItem(item, this.count, this.nbt, this.dataComponents);
        }

        public @Range(from=0L, to=0x7FFFFFFFL) int count() {
            return this.count;
        }

        public ShowItem count(@Range(from=0L, to=0x7FFFFFFFL) int count) {
            if (count == this.count) {
                return this;
            }
            return new ShowItem(this.item, count, this.nbt, this.dataComponents);
        }

        @ApiStatus.Obsolete
        public @Nullable BinaryTagHolder nbt() {
            return this.nbt;
        }

        @ApiStatus.Obsolete
        public ShowItem nbt(@Nullable BinaryTagHolder nbt) {
            if (Objects.equals(nbt, this.nbt)) {
                return this;
            }
            return new ShowItem(this.item, this.count, nbt, this.dataComponents);
        }

        public Map<Key, DataComponentValue> dataComponents() {
            return this.dataComponents;
        }

        public ShowItem dataComponents(Map<Key, DataComponentValue> holder) {
            if (Objects.equals(this.dataComponents, holder)) {
                return this;
            }
            return new ShowItem(this.item, this.count, this.nbt, Map.copyOf(holder));
        }

        public <V extends DataComponentValue> Map<Key, V> dataComponentsAs(Class<V> targetType) {
            if (this.dataComponents.isEmpty()) {
                return Map.of();
            }
            HashMap<Key, V> results = new HashMap<Key, V>(this.dataComponents.size());
            for (Map.Entry<Key, DataComponentValue> entry : this.dataComponents.entrySet()) {
                results.put(entry.getKey(), DataComponentValueConverterRegistry.convert(targetType, entry.getKey(), entry.getValue()));
            }
            return Map.copyOf(results);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ShowItem)) {
                return false;
            }
            ShowItem showItem = (ShowItem)o;
            return this.count == showItem.count && this.item.equals((Object)showItem.item) && Objects.equals(this.nbt, showItem.nbt) && this.dataComponents.equals(showItem.dataComponents);
        }

        public int hashCode() {
            int result = this.item.hashCode();
            result = 31 * result + this.count;
            result = 31 * result + Objects.hashCode(this.nbt);
            result = 31 * result + this.dataComponents.hashCode();
            return result;
        }

        public String toString() {
            return "ShowItem{item=" + String.valueOf(this.item) + ", count=" + this.count + ", nbt=" + String.valueOf(this.nbt) + ", dataComponents=" + String.valueOf(this.dataComponents) + "}";
        }
    }

    public static final class ShowEntity {
        private final Key type;
        private final UUID id;
        private final @Nullable Component name;

        public static ShowEntity showEntity(Key type, UUID id) {
            return ShowEntity.showEntity(type, id, null);
        }

        public static ShowEntity showEntity(Keyed type, UUID id) {
            return ShowEntity.showEntity(type, id, null);
        }

        public static ShowEntity showEntity(Key type, UUID id, @Nullable Component name) {
            return new ShowEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(id, "id"), name);
        }

        public static ShowEntity showEntity(Keyed type, UUID id, @Nullable Component name) {
            return new ShowEntity(Objects.requireNonNull(type, "type").key(), Objects.requireNonNull(id, "id"), name);
        }

        private ShowEntity(Key type, UUID id, @Nullable Component name) {
            this.type = type;
            this.id = id;
            this.name = name;
        }

        public Key type() {
            return this.type;
        }

        public ShowEntity type(Key type) {
            if (Objects.requireNonNull(type, "type").equals((Object)this.type)) {
                return this;
            }
            return new ShowEntity(type, this.id, this.name);
        }

        public ShowEntity type(Keyed type) {
            return this.type(Objects.requireNonNull(type, "type").key());
        }

        public UUID id() {
            return this.id;
        }

        public ShowEntity id(UUID id) {
            if (Objects.requireNonNull(id).equals(this.id)) {
                return this;
            }
            return new ShowEntity(this.type, id, this.name);
        }

        public @Nullable Component name() {
            return this.name;
        }

        public ShowEntity name(@Nullable Component name) {
            if (Objects.equals(name, this.name)) {
                return this;
            }
            return new ShowEntity(this.type, this.id, name);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ShowEntity)) {
                return false;
            }
            ShowEntity that = (ShowEntity)o;
            return this.type.equals((Object)that.type) && this.id.equals(that.id) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.id.hashCode();
            result = 31 * result + Objects.hashCode(this.name);
            return result;
        }

        public String toString() {
            return "ShowEntity{type=" + String.valueOf(this.type) + ", id=" + String.valueOf(this.id) + ", name=" + String.valueOf(this.name) + "}";
        }
    }
}

