/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.format;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.MutableStyleSetter;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.StyleGetter;
import net.kyori.adventure.text.format.StyleImpl;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.Buildable;
import net.kyori.adventure.util.MonkeyBars;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

public sealed interface Style
extends StyleGetter,
StyleSetter<Style>,
Buildable<Builder>
permits StyleImpl {
    public static final Key DEFAULT_FONT = Key.key((String)"default");

    public static Style empty() {
        return StyleImpl.EMPTY;
    }

    public static Builder style() {
        return new StyleImpl.BuilderImpl();
    }

    public static Style style(Consumer<Builder> consumer) {
        return (Style)AbstractBuilder.configureAndBuild(Style.style(), consumer);
    }

    public static Style style(@Nullable TextColor color) {
        return Style.empty().color(color);
    }

    public static Style style(TextDecoration decoration) {
        return Style.style().decoration(decoration, true).build();
    }

    public static Style style(@Nullable TextColor color, TextDecoration ... decorations) {
        Builder builder = Style.style();
        builder.color(color);
        builder.decorate(decorations);
        return builder.build();
    }

    public static Style style(@Nullable TextColor color, Set<TextDecoration> decorations) {
        Builder builder = Style.style();
        builder.color(color);
        if (!decorations.isEmpty()) {
            for (TextDecoration decoration : decorations) {
                builder.decoration(decoration, true);
            }
        }
        return builder.build();
    }

    public static Style style(StyleBuilderApplicable ... applicables) {
        int length = applicables.length;
        if (length == 0) {
            return Style.empty();
        }
        Builder builder = Style.style();
        for (StyleBuilderApplicable applicable : applicables) {
            if (applicable == null) continue;
            applicable.styleApply(builder);
        }
        return builder.build();
    }

    public static Style style(Iterable<? extends StyleBuilderApplicable> applicables) {
        Builder builder = Style.style();
        for (StyleBuilderApplicable styleBuilderApplicable : applicables) {
            styleBuilderApplicable.styleApply(builder);
        }
        return builder.build();
    }

    default public Style edit(Consumer<Builder> consumer) {
        return this.edit(consumer, Merge.Strategy.ALWAYS);
    }

    default public Style edit(Consumer<Builder> consumer, Merge.Strategy strategy) {
        return Style.style((Builder style) -> {
            if (strategy == Merge.Strategy.ALWAYS) {
                style.merge(this, strategy);
            }
            consumer.accept((Builder)style);
            if (strategy == Merge.Strategy.IF_ABSENT_ON_TARGET) {
                style.merge(this, strategy);
            }
        });
    }

    @Override
    public @Nullable Key font();

    @Override
    public Style font(@Nullable Key var1);

    @Override
    public @Nullable TextColor color();

    @Override
    public Style color(@Nullable TextColor var1);

    @Override
    public Style colorIfAbsent(@Nullable TextColor var1);

    @Override
    default public boolean hasDecoration(TextDecoration decoration) {
        return StyleGetter.super.hasDecoration(decoration);
    }

    @Override
    public TextDecoration.State decoration(TextDecoration var1);

    @Override
    default public Style decorate(TextDecoration decoration) {
        return (Style)StyleSetter.super.decorate(decoration);
    }

    @Override
    default public Style decoration(TextDecoration decoration, boolean flag) {
        return (Style)StyleSetter.super.decoration(decoration, flag);
    }

    @Override
    public Style decoration(TextDecoration var1, TextDecoration.State var2);

    @Override
    public Style decorationIfAbsent(TextDecoration var1, TextDecoration.State var2);

    @Override
    default public @Unmodifiable Map<TextDecoration, TextDecoration.State> decorations() {
        return StyleGetter.super.decorations();
    }

    @Override
    public Style decorations(Map<TextDecoration, TextDecoration.State> var1);

    @Override
    public @Nullable ClickEvent<?> clickEvent();

    @Override
    public Style clickEvent(@Nullable ClickEvent<?> var1);

    @Override
    public @Nullable HoverEvent<?> hoverEvent();

    @Override
    public Style hoverEvent(@Nullable HoverEventSource<?> var1);

    @Override
    public @Nullable String insertion();

    @Override
    public Style insertion(@Nullable String var1);

    default public Style merge(Style that) {
        return this.merge(that, Merge.all());
    }

    default public Style merge(Style that, Merge.Strategy strategy) {
        return this.merge(that, strategy, Merge.all());
    }

    default public Style merge(Style that, Merge merge) {
        return this.merge(that, Collections.singleton(merge));
    }

    default public Style merge(Style that, Merge.Strategy strategy, Merge merge) {
        return this.merge(that, strategy, Collections.singleton(merge));
    }

    default public Style merge(Style that, Merge ... merges) {
        return this.merge(that, Merge.merges(merges));
    }

    default public Style merge(Style that, Merge.Strategy strategy, Merge ... merges) {
        return this.merge(that, strategy, Merge.merges(merges));
    }

    default public Style merge(Style that, Set<Merge> merges) {
        return this.merge(that, Merge.Strategy.ALWAYS, merges);
    }

    public Style merge(Style var1, Merge.Strategy var2, Set<Merge> var3);

    public Style unmerge(Style var1);

    public boolean isEmpty();

    @Override
    public Builder toBuilder();

    public static sealed interface Builder
    extends AbstractBuilder<Style>,
    MutableStyleSetter<Builder>
    permits StyleImpl.BuilderImpl {
        @Override
        @Contract(value="_ -> this")
        public Builder font(@Nullable Key var1);

        @Override
        @Contract(value="_ -> this")
        public Builder color(@Nullable TextColor var1);

        @Override
        @Contract(value="_ -> this")
        public Builder colorIfAbsent(@Nullable TextColor var1);

        @Override
        @Contract(value="_ -> this")
        default public Builder decorate(TextDecoration decoration) {
            return (Builder)MutableStyleSetter.super.decorate(decoration);
        }

        @Override
        @Contract(value="_ -> this")
        default public Builder decorate(TextDecoration ... decorations) {
            return (Builder)MutableStyleSetter.super.decorate(decorations);
        }

        @Override
        @Contract(value="_, _ -> this")
        default public Builder decoration(TextDecoration decoration, boolean flag) {
            return (Builder)MutableStyleSetter.super.decoration(decoration, flag);
        }

        @Override
        @Contract(value="_ -> this")
        default public Builder decorations(Map<TextDecoration, TextDecoration.State> decorations) {
            return (Builder)MutableStyleSetter.super.decorations((Map)decorations);
        }

        @Override
        @Contract(value="_, _ -> this")
        public Builder decoration(TextDecoration var1, TextDecoration.State var2);

        @Override
        @Contract(value="_, _ -> this")
        public Builder decorationIfAbsent(TextDecoration var1, TextDecoration.State var2);

        @Override
        @Contract(value="_ -> this")
        public Builder clickEvent(@Nullable ClickEvent<?> var1);

        @Override
        @Contract(value="_ -> this")
        public Builder hoverEvent(@Nullable HoverEventSource<?> var1);

        @Override
        @Contract(value="_ -> this")
        public Builder insertion(@Nullable String var1);

        @Contract(value="_ -> this")
        default public Builder merge(Style that) {
            return this.merge(that, Merge.all());
        }

        @Contract(value="_, _ -> this")
        default public Builder merge(Style that, Merge.Strategy strategy) {
            return this.merge(that, strategy, Merge.all());
        }

        @Contract(value="_, _ -> this")
        default public Builder merge(Style that, Merge ... merges) {
            if (merges.length == 0) {
                return this;
            }
            return this.merge(that, Merge.merges(merges));
        }

        @Contract(value="_, _, _ -> this")
        default public Builder merge(Style that, Merge.Strategy strategy, Merge ... merges) {
            if (merges.length == 0) {
                return this;
            }
            return this.merge(that, strategy, Merge.merges(merges));
        }

        @Contract(value="_, _ -> this")
        default public Builder merge(Style that, Set<Merge> merges) {
            return this.merge(that, Merge.Strategy.ALWAYS, merges);
        }

        @Contract(value="_, _, _ -> this")
        public Builder merge(Style var1, Merge.Strategy var2, Set<Merge> var3);

        @Contract(value="_ -> this")
        default public Builder apply(StyleBuilderApplicable applicable) {
            applicable.styleApply(this);
            return this;
        }

        @Override
        public Style build();
    }

    public static enum Merge {
        COLOR,
        SHADOW_COLOR,
        DECORATIONS,
        EVENTS,
        INSERTION,
        FONT;

        static final Set<Merge> ALL;
        static final Set<Merge> COLOR_AND_DECORATIONS;

        public static @Unmodifiable Set<Merge> all() {
            return ALL;
        }

        public static @Unmodifiable Set<Merge> colorAndDecorations() {
            return COLOR_AND_DECORATIONS;
        }

        public static @Unmodifiable Set<Merge> merges(Merge ... merges) {
            return MonkeyBars.enumSet(Merge.class, (Enum[])merges);
        }

        static boolean hasAll(Set<Merge> merges) {
            return merges.size() == ALL.size();
        }

        static {
            ALL = Merge.merges(Merge.values());
            COLOR_AND_DECORATIONS = Merge.merges(COLOR, DECORATIONS);
        }

        public static enum Strategy {
            ALWAYS,
            NEVER,
            IF_ABSENT_ON_TARGET;

        }
    }
}

