/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.format;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.DecorationMap;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ARGBLike;
import org.jspecify.annotations.Nullable;

final class StyleImpl
implements Style {
    static final StyleImpl EMPTY = new StyleImpl(null, null, null, DecorationMap.EMPTY, null, null, null);
    final @Nullable Key font;
    final @Nullable TextColor color;
    final @Nullable ShadowColor shadowColor;
    final DecorationMap decorations;
    final @Nullable ClickEvent<?> clickEvent;
    final @Nullable HoverEvent<?> hoverEvent;
    final @Nullable String insertion;

    StyleImpl(@Nullable Key font, @Nullable TextColor color, @Nullable ShadowColor shadowColor, Map<TextDecoration, TextDecoration.State> decorations, @Nullable ClickEvent<?> clickEvent, @Nullable HoverEvent<?> hoverEvent, @Nullable String insertion) {
        this.font = font;
        this.color = color;
        this.shadowColor = shadowColor;
        this.decorations = DecorationMap.fromMap(decorations);
        this.clickEvent = clickEvent;
        this.hoverEvent = hoverEvent;
        this.insertion = insertion;
    }

    @Override
    public @Nullable Key font() {
        return this.font;
    }

    @Override
    public Style font(@Nullable Key font) {
        if (Objects.equals(this.font, font)) {
            return this;
        }
        return new StyleImpl(font, this.color, this.shadowColor, this.decorations, this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    public @Nullable TextColor color() {
        return this.color;
    }

    @Override
    public Style color(@Nullable TextColor color) {
        if (Objects.equals(this.color, color)) {
            return this;
        }
        return new StyleImpl(this.font, color, this.shadowColor, this.decorations, this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    public Style colorIfAbsent(@Nullable TextColor color) {
        if (this.color == null) {
            return this.color(color);
        }
        return this;
    }

    @Override
    public @Nullable ShadowColor shadowColor() {
        return this.shadowColor;
    }

    @Override
    public Style shadowColor(@Nullable ARGBLike argb) {
        if (Objects.equals(this.shadowColor, argb)) {
            return this;
        }
        return new StyleImpl(this.font, this.color, argb == null ? null : ShadowColor.shadowColor(argb), this.decorations, this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    public Style shadowColorIfAbsent(@Nullable ARGBLike argb) {
        if (this.shadowColor == null) {
            return this.shadowColor(argb);
        }
        return this;
    }

    @Override
    public TextDecoration.State decoration(TextDecoration decoration) {
        @Nullable TextDecoration.State state = this.decorations.get(decoration);
        if (state != null) {
            return state;
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    public Style decoration(TextDecoration decoration, TextDecoration.State state) {
        Objects.requireNonNull(state, "state");
        if (this.decoration(decoration) == state) {
            return this;
        }
        return new StyleImpl(this.font, this.color, this.shadowColor, this.decorations.with(decoration, state), this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    public Style decorationIfAbsent(TextDecoration decoration, TextDecoration.State state) {
        Objects.requireNonNull(state, "state");
        @Nullable TextDecoration.State oldState = this.decorations.get(decoration);
        if (oldState == TextDecoration.State.NOT_SET) {
            return new StyleImpl(this.font, this.color, this.shadowColor, this.decorations.with(decoration, state), this.clickEvent, this.hoverEvent, this.insertion);
        }
        if (oldState != null) {
            return this;
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    public Map<TextDecoration, TextDecoration.State> decorations() {
        return this.decorations;
    }

    @Override
    public Style decorations(Map<TextDecoration, TextDecoration.State> decorations) {
        return new StyleImpl(this.font, this.color, this.shadowColor, DecorationMap.merge(decorations, this.decorations), this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    public @Nullable ClickEvent<?> clickEvent() {
        return this.clickEvent;
    }

    @Override
    public Style clickEvent(@Nullable ClickEvent<?> event) {
        return new StyleImpl(this.font, this.color, this.shadowColor, this.decorations, event, this.hoverEvent, this.insertion);
    }

    @Override
    public @Nullable HoverEvent<?> hoverEvent() {
        return this.hoverEvent;
    }

    @Override
    public Style hoverEvent(@Nullable HoverEventSource<?> source) {
        return new StyleImpl(this.font, this.color, this.shadowColor, this.decorations, this.clickEvent, HoverEventSource.unbox(source), this.insertion);
    }

    @Override
    public @Nullable String insertion() {
        return this.insertion;
    }

    @Override
    public Style insertion(@Nullable String insertion) {
        if (Objects.equals(this.insertion, insertion)) {
            return this;
        }
        return new StyleImpl(this.font, this.color, this.shadowColor, this.decorations, this.clickEvent, this.hoverEvent, insertion);
    }

    @Override
    public Style merge(Style that, Style.Merge.Strategy strategy, Set<Style.Merge> merges) {
        if (StyleImpl.nothingToMerge(that, strategy, merges)) {
            return this;
        }
        if (this.isEmpty() && Style.Merge.hasAll(merges)) {
            return that;
        }
        Style.Builder builder = this.toBuilder();
        builder.merge(that, strategy, merges);
        return builder.build();
    }

    @Override
    public Style unmerge(Style that) {
        if (this.isEmpty()) {
            return this;
        }
        BuilderImpl builder = new BuilderImpl(this);
        if (Objects.equals(this.font(), that.font())) {
            builder.font(null);
        }
        if (Objects.equals(this.color(), that.color())) {
            builder.color(null);
        }
        if (Objects.equals(this.shadowColor(), that.shadowColor())) {
            builder.shadowColor(null);
        }
        for (TextDecoration decoration : DecorationMap.DECORATIONS) {
            if (this.decoration(decoration) != that.decoration(decoration)) continue;
            builder.decoration(decoration, TextDecoration.State.NOT_SET);
        }
        if (Objects.equals(this.clickEvent(), that.clickEvent())) {
            builder.clickEvent((ClickEvent)null);
        }
        if (Objects.equals(this.hoverEvent(), that.hoverEvent())) {
            builder.hoverEvent((HoverEventSource)null);
        }
        if (Objects.equals(this.insertion(), that.insertion())) {
            builder.insertion(null);
        }
        return builder.build();
    }

    static boolean nothingToMerge(Style mergeFrom, Style.Merge.Strategy strategy, Set<Style.Merge> merges) {
        if (strategy == Style.Merge.Strategy.NEVER) {
            return true;
        }
        if (mergeFrom.isEmpty()) {
            return true;
        }
        return merges.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public Style.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StyleImpl)) {
            return false;
        }
        StyleImpl that = (StyleImpl)other;
        return Objects.equals(this.color, that.color) && this.decorations.equals(that.decorations) && Objects.equals(this.shadowColor, that.shadowColor) && Objects.equals(this.clickEvent, that.clickEvent) && Objects.equals(this.hoverEvent, that.hoverEvent) && Objects.equals(this.insertion, that.insertion) && Objects.equals(this.font, that.font);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.color);
        result = 31 * result + Objects.hashCode(this.shadowColor);
        result = 31 * result + this.decorations.hashCode();
        result = 31 * result + Objects.hashCode(this.clickEvent);
        result = 31 * result + Objects.hashCode(this.hoverEvent);
        result = 31 * result + Objects.hashCode(this.insertion);
        result = 31 * result + Objects.hashCode(this.font);
        return result;
    }

    static final class BuilderImpl
    implements Style.Builder {
        @Nullable Key font;
        @Nullable TextColor color;
        @Nullable ShadowColor shadowColor;
        DecorationMap decorations;
        @Nullable ClickEvent<?> clickEvent;
        @Nullable HoverEvent<?> hoverEvent;
        @Nullable String insertion;

        BuilderImpl() {
            this.decorations = DecorationMap.EMPTY;
        }

        BuilderImpl(StyleImpl style) {
            this.color = style.color;
            this.shadowColor = style.shadowColor;
            this.decorations = style.decorations;
            this.clickEvent = style.clickEvent;
            this.hoverEvent = style.hoverEvent;
            this.insertion = style.insertion;
            this.font = style.font;
        }

        @Override
        public Style.Builder font(@Nullable Key font) {
            this.font = font;
            return this;
        }

        @Override
        public Style.Builder color(@Nullable TextColor color) {
            this.color = color;
            return this;
        }

        @Override
        public Style.Builder colorIfAbsent(@Nullable TextColor color) {
            if (this.color == null) {
                this.color = color;
            }
            return this;
        }

        @Override
        public Style.Builder shadowColor(@Nullable ARGBLike argb) {
            this.shadowColor = argb == null ? null : ShadowColor.shadowColor(argb);
            return this;
        }

        @Override
        public Style.Builder shadowColorIfAbsent(@Nullable ARGBLike argb) {
            if (this.shadowColor == null) {
                this.shadowColor = argb == null ? null : ShadowColor.shadowColor(argb);
            }
            return this;
        }

        @Override
        public Style.Builder decoration(TextDecoration decoration, TextDecoration.State state) {
            Objects.requireNonNull(state, "state");
            Objects.requireNonNull(decoration, "decoration");
            this.decorations = this.decorations.with(decoration, state);
            return this;
        }

        @Override
        public Style.Builder decorationIfAbsent(TextDecoration decoration, TextDecoration.State state) {
            Objects.requireNonNull(state, "state");
            @Nullable TextDecoration.State oldState = this.decorations.get(decoration);
            if (oldState == TextDecoration.State.NOT_SET) {
                this.decorations = this.decorations.with(decoration, state);
            }
            if (oldState != null) {
                return this;
            }
            throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
        }

        @Override
        public Style.Builder clickEvent(@Nullable ClickEvent<?> event) {
            this.clickEvent = event;
            return this;
        }

        @Override
        public Style.Builder hoverEvent(@Nullable HoverEventSource<?> source) {
            this.hoverEvent = HoverEventSource.unbox(source);
            return this;
        }

        @Override
        public Style.Builder insertion(@Nullable String insertion) {
            this.insertion = insertion;
            return this;
        }

        @Override
        public Style.Builder merge(Style that, Style.Merge.Strategy strategy, Set<Style.Merge> merges) {
            Key font;
            String insertion;
            ShadowColor shadowColor;
            TextColor color;
            Objects.requireNonNull(that, "style");
            Objects.requireNonNull(strategy, "strategy");
            Objects.requireNonNull(merges, "merges");
            if (StyleImpl.nothingToMerge(that, strategy, merges)) {
                return this;
            }
            if (merges.contains((Object)Style.Merge.COLOR) && (color = that.color()) != null && (strategy == Style.Merge.Strategy.ALWAYS || strategy == Style.Merge.Strategy.IF_ABSENT_ON_TARGET && this.color == null)) {
                this.color(color);
            }
            if (merges.contains((Object)Style.Merge.SHADOW_COLOR) && (shadowColor = that.shadowColor()) != null && (strategy == Style.Merge.Strategy.ALWAYS || strategy == Style.Merge.Strategy.IF_ABSENT_ON_TARGET && this.shadowColor == null)) {
                this.shadowColor(shadowColor);
            }
            if (merges.contains((Object)Style.Merge.DECORATIONS)) {
                for (TextDecoration decoration : DecorationMap.DECORATIONS) {
                    TextDecoration.State state = that.decoration(decoration);
                    if (state == TextDecoration.State.NOT_SET) continue;
                    if (strategy == Style.Merge.Strategy.ALWAYS) {
                        this.decoration(decoration, state);
                        continue;
                    }
                    if (strategy != Style.Merge.Strategy.IF_ABSENT_ON_TARGET) continue;
                    this.decorationIfAbsent(decoration, state);
                }
            }
            if (merges.contains((Object)Style.Merge.EVENTS)) {
                HoverEvent<?> hoverEvent;
                ClickEvent<?> clickEvent = that.clickEvent();
                if (clickEvent != null && (strategy == Style.Merge.Strategy.ALWAYS || strategy == Style.Merge.Strategy.IF_ABSENT_ON_TARGET && this.clickEvent == null)) {
                    this.clickEvent((ClickEvent)clickEvent);
                }
                if ((hoverEvent = that.hoverEvent()) != null && (strategy == Style.Merge.Strategy.ALWAYS || strategy == Style.Merge.Strategy.IF_ABSENT_ON_TARGET && this.hoverEvent == null)) {
                    this.hoverEvent(hoverEvent);
                }
            }
            if (merges.contains((Object)Style.Merge.INSERTION) && (insertion = that.insertion()) != null && (strategy == Style.Merge.Strategy.ALWAYS || strategy == Style.Merge.Strategy.IF_ABSENT_ON_TARGET && this.insertion == null)) {
                this.insertion(insertion);
            }
            if (merges.contains((Object)Style.Merge.FONT) && (font = that.font()) != null && (strategy == Style.Merge.Strategy.ALWAYS || strategy == Style.Merge.Strategy.IF_ABSENT_ON_TARGET && this.font == null)) {
                this.font(font);
            }
            return this;
        }

        @Override
        public StyleImpl build() {
            if (this.isEmpty()) {
                return EMPTY;
            }
            return new StyleImpl(this.font, this.color, this.shadowColor, this.decorations, this.clickEvent, this.hoverEvent, this.insertion);
        }

        private boolean isEmpty() {
            return this.color == null && this.shadowColor == null && this.decorations == DecorationMap.EMPTY && this.clickEvent == null && this.hoverEvent == null && this.insertion == null && this.font == null;
        }
    }
}

