/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.format;

import java.util.Objects;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextDecorationAndState;
import net.kyori.adventure.text.format.TextDecorationAndStateImpl;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.util.Index;
import net.kyori.adventure.util.TriState;
import org.jspecify.annotations.Nullable;

public enum TextDecoration implements StyleBuilderApplicable,
TextFormat
{
    OBFUSCATED("obfuscated"),
    BOLD("bold"),
    STRIKETHROUGH("strikethrough"),
    UNDERLINED("underlined"),
    ITALIC("italic");

    public static final Index<String, TextDecoration> NAMES;
    private final String name;

    private TextDecoration(String name) {
        this.name = name;
    }

    public final TextDecorationAndState withState(boolean state) {
        return new TextDecorationAndStateImpl(this, State.byBoolean(state));
    }

    public final TextDecorationAndState withState(State state) {
        return new TextDecorationAndStateImpl(this, state);
    }

    public final TextDecorationAndState withState(TriState state) {
        return new TextDecorationAndStateImpl(this, State.byTriState(state));
    }

    @Override
    public void styleApply(Style.Builder style) {
        style.decorate(this);
    }

    public String toString() {
        return this.name;
    }

    static {
        NAMES = Index.create(TextDecoration.class, constant -> constant.name);
    }

    public static enum State {
        NOT_SET("not_set"),
        FALSE("false"),
        TRUE("true");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static State byBoolean(boolean flag) {
            return flag ? TRUE : FALSE;
        }

        public static State byBoolean(@Nullable Boolean flag) {
            return flag == null ? NOT_SET : State.byBoolean((boolean)flag);
        }

        public static State byTriState(TriState flag) {
            return switch (Objects.requireNonNull(flag, "flag")) {
                default -> throw new MatchException(null, null);
                case TriState.TRUE -> TRUE;
                case TriState.FALSE -> FALSE;
                case TriState.NOT_SET -> NOT_SET;
            };
        }
    }
}

