/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.title;

import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.TitleImpl;
import net.kyori.adventure.title.TitlePart;
import net.kyori.adventure.util.Ticks;
import org.jetbrains.annotations.UnknownNullability;
import org.jspecify.annotations.Nullable;

public sealed interface Title
permits TitleImpl {
    public static final Times DEFAULT_TIMES = Times.times(Ticks.duration(10L), Ticks.duration(70L), Ticks.duration(20L));

    public static Title title(Component title, Component subtitle) {
        return Title.title(title, subtitle, DEFAULT_TIMES);
    }

    public static Title title(Component title, Component subtitle, @Nullable Times times) {
        return new TitleImpl(title, subtitle, times);
    }

    public static Title title(Component title, Component subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        return new TitleImpl(title, subtitle, Times.times(Ticks.duration(fadeInTicks), Ticks.duration(stayTicks), Ticks.duration(fadeOutTicks)));
    }

    public Component title();

    public Component subtitle();

    public @Nullable Times times();

    public <T> @UnknownNullability T part(TitlePart<T> var1);

    public static sealed interface Times
    permits TitleImpl.TimesImpl {
        public static Times times(Duration fadeIn, Duration stay, Duration fadeOut) {
            return new TitleImpl.TimesImpl(fadeIn, stay, fadeOut);
        }

        public Duration fadeIn();

        public Duration stay();

        public Duration fadeOut();
    }
}

