/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.translation;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.ComponentTranslationStore;
import net.kyori.adventure.translation.MessageFormatTranslationStore;
import net.kyori.adventure.translation.Translator;

public interface TranslationStore<T>
extends Translator {
    public static TranslationStore<Component> component(Key name) {
        return new ComponentTranslationStore(Objects.requireNonNull(name, "name"));
    }

    public static StringBased<MessageFormat> messageFormat(Key name) {
        return new MessageFormatTranslationStore(Objects.requireNonNull(name, "name"));
    }

    public boolean contains(String var1);

    public boolean contains(String var1, Locale var2);

    @Override
    default public boolean canTranslate(String key, Locale locale) {
        return Translator.super.canTranslate(key, locale);
    }

    public void defaultLocale(Locale var1);

    public void register(String var1, Locale var2, T var3);

    public void registerAll(Locale var1, Map<String, T> var2);

    public void registerAll(Locale var1, Set<String> var2, Function<String, T> var3);

    public void unregister(String var1);

    public static interface StringBased<T>
    extends TranslationStore<T> {
        public void registerAll(Locale var1, Path var2, boolean var3);

        public void registerAll(Locale var1, ResourceBundle var2, boolean var3);
    }
}

