/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.util;

import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.util.InheritanceAwareMapImpl;
import org.jetbrains.annotations.CheckReturnValue;
import org.jspecify.annotations.Nullable;

public interface InheritanceAwareMap<C, V> {
    public static <K, E> InheritanceAwareMap<K, E> empty() {
        return InheritanceAwareMapImpl.EMPTY;
    }

    public static <K, E> Builder<K, E> builder() {
        return new InheritanceAwareMapImpl.BuilderImpl();
    }

    public static <K, E> Builder<K, E> builder(InheritanceAwareMap<? extends K, ? extends E> existing) {
        return new InheritanceAwareMapImpl.BuilderImpl<K, E>().putAll(existing);
    }

    public boolean containsKey(Class<? extends C> var1);

    public @Nullable V get(Class<? extends C> var1);

    @CheckReturnValue
    public InheritanceAwareMap<C, V> with(Class<? extends C> var1, V var2);

    @CheckReturnValue
    public InheritanceAwareMap<C, V> without(Class<? extends C> var1);

    public static interface Builder<C, V>
    extends AbstractBuilder<InheritanceAwareMap<C, V>> {
        public Builder<C, V> strict(boolean var1);

        public Builder<C, V> put(Class<? extends C> var1, V var2);

        public Builder<C, V> remove(Class<? extends C> var1);

        public Builder<C, V> putAll(InheritanceAwareMap<? extends C, ? extends V> var1);
    }
}

