/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.key;

import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import net.kyori.adventure.key.KeyImpl;
import net.kyori.adventure.key.KeyPattern;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.key.Namespaced;
import org.jspecify.annotations.Nullable;

public interface Key
extends Comparable<Key>,
Namespaced,
Keyed {
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    public static final char DEFAULT_SEPARATOR = ':';

    public static Key key(@KeyPattern String string) {
        return Key.key(string, ':');
    }

    public static Key key(String string, char character) {
        Objects.requireNonNull(string, "string");
        int index = string.indexOf(character);
        String namespace = index >= 1 ? string.substring(0, index) : MINECRAFT_NAMESPACE;
        String value = index >= 0 ? string.substring(index + 1) : string;
        return Key.key(namespace, value);
    }

    public static Key key(Namespaced namespaced, @KeyPattern.Value String value) {
        return Key.key(Objects.requireNonNull(namespaced, "namespaced").namespace(), value);
    }

    public static Key key(@KeyPattern.Namespace String namespace, @KeyPattern.Value String value) {
        return new KeyImpl(namespace, value);
    }

    public static Comparator<? super Key> comparator() {
        return KeyImpl.COMPARATOR;
    }

    public static boolean parseable(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int index = string.indexOf(58);
        String namespace = index >= 1 ? string.substring(0, index) : MINECRAFT_NAMESPACE;
        String value = index >= 0 ? string.substring(index + 1) : string;
        return Key.parseableNamespace(namespace) && Key.parseableValue(value);
    }

    public static boolean parseableNamespace(String namespace) {
        return Key.checkNamespace(namespace).isEmpty();
    }

    public static OptionalInt checkNamespace(String namespace) {
        Objects.requireNonNull(namespace, "namespace");
        int length = namespace.length();
        for (int i = 0; i < length; ++i) {
            if (Key.allowedInNamespace(namespace.charAt(i))) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public static boolean parseableValue(String value) {
        return Key.checkValue(value).isEmpty();
    }

    public static OptionalInt checkValue(String value) {
        Objects.requireNonNull(value, "value");
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            if (Key.allowedInValue(value.charAt(i))) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public static boolean allowedInNamespace(char character) {
        return KeyImpl.allowedInNamespace(character);
    }

    public static boolean allowedInValue(char character) {
        return KeyImpl.allowedInValue(character);
    }

    @Override
    @KeyPattern.Namespace
    public String namespace();

    @KeyPattern.Value
    public String value();

    public String asString();

    default public String asMinimalString() {
        if (this.namespace().equals(MINECRAFT_NAMESPACE)) {
            return this.value();
        }
        return this.asString();
    }

    @Override
    default public int compareTo(Key that) {
        return Key.comparator().compare(this, that);
    }

    @Override
    default public Key key() {
        return this;
    }
}

