/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.key;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;

record KeyImpl(String namespace, String value) implements Key
{
    static final Comparator<? super Key> COMPARATOR = Comparator.comparing(Key::value).thenComparing(Key::namespace);

    KeyImpl {
        KeyImpl.checkError("namespace", namespace, namespace, value, Key.checkNamespace(namespace), "[a-z0-9_\\-.]+");
        KeyImpl.checkError("value", value, namespace, value, Key.checkValue(value), "[a-z0-9_\\-./]+");
    }

    static void checkError(String name, String checkPart, String namespace, String value, OptionalInt index, String pattern) {
        Objects.requireNonNull(checkPart, name);
        if (index.isPresent()) {
            int indexValue = index.getAsInt();
            char character = checkPart.charAt(indexValue);
            throw new InvalidKeyException(namespace, value, String.format("Non " + pattern + " character in %s of Key[%s] at index %d ('%s', bytes: %s)", name, KeyImpl.asString(namespace, value), indexValue, Character.valueOf(character), Arrays.toString(String.valueOf(character).getBytes(StandardCharsets.UTF_8))));
        }
    }

    static boolean allowedInNamespace(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.';
    }

    static boolean allowedInValue(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.' || character == '/';
    }

    @Override
    public String asString() {
        return KeyImpl.asString(this.namespace, this.value);
    }

    private static String asString(String namespace, String value) {
        return namespace + ":" + value;
    }

    @Override
    public String toString() {
        return this.asString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Key)) {
            return false;
        }
        Key that = (Key)other;
        return Objects.equals(this.namespace, that.namespace()) && Objects.equals(this.value, that.value());
    }

    @Override
    public int compareTo(Key that) {
        return Key.super.compareTo(that);
    }
}

