/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.NumberBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import org.jetbrains.annotations.Debug;
import org.jspecify.annotations.Nullable;

@Debug.Renderer(text="\"CompoundBinaryTag[length=\" + this.tags.size() + \"]\"", childrenArray="this.tags.entrySet().toArray()", hasChildren="!this.tags.isEmpty()")
record CompoundBinaryTagImpl(Map<String, BinaryTag> tags) implements CompoundBinaryTag
{
    static final CompoundBinaryTag EMPTY = new CompoundBinaryTagImpl(Map.of());

    static CompoundBinaryTag create(Map<String, BinaryTag> tags) {
        return new CompoundBinaryTagImpl(Map.copyOf(tags));
    }

    @Override
    public boolean contains(String key) {
        return this.tags.containsKey(key);
    }

    @Override
    public boolean contains(String key, BinaryTagType<?> type) {
        BinaryTag tag = this.tags.get(Objects.requireNonNull(key, "key"));
        return tag != null && Objects.requireNonNull(type, "type").test(tag.type());
    }

    @Override
    public Set<String> keySet() {
        return Set.copyOf(this.tags.keySet());
    }

    @Override
    public @Nullable BinaryTag get(String key) {
        return this.tags.get(key);
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public CompoundBinaryTag put(String key, BinaryTag tag) {
        return this.edit(map -> map.put(key, tag));
    }

    @Override
    public CompoundBinaryTag put(CompoundBinaryTag tag) {
        return this.edit(map -> {
            for (String key : tag.keySet()) {
                map.put(key, tag.get(key));
            }
        });
    }

    @Override
    public CompoundBinaryTag put(Map<String, ? extends BinaryTag> tags) {
        return this.edit(map -> map.putAll(tags));
    }

    @Override
    public CompoundBinaryTag remove(String key, @Nullable Consumer<? super BinaryTag> removed) {
        if (!this.tags.containsKey(key)) {
            return this;
        }
        return this.edit(map -> {
            BinaryTag tag = (BinaryTag)map.remove(key);
            if (removed != null) {
                removed.accept(tag);
            }
        });
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        if (this.contains(key, BinaryTagTypes.BYTE)) {
            return ((NumberBinaryTag)this.tags.get(key)).byteValue();
        }
        return defaultValue;
    }

    @Override
    public short getShort(String key, short defaultValue) {
        if (this.contains(key, BinaryTagTypes.SHORT)) {
            return ((NumberBinaryTag)this.tags.get(key)).shortValue();
        }
        return defaultValue;
    }

    @Override
    public int getInt(String key, int defaultValue) {
        if (this.contains(key, BinaryTagTypes.INT)) {
            return ((NumberBinaryTag)this.tags.get(key)).intValue();
        }
        return defaultValue;
    }

    @Override
    public long getLong(String key, long defaultValue) {
        if (this.contains(key, BinaryTagTypes.LONG)) {
            return ((NumberBinaryTag)this.tags.get(key)).longValue();
        }
        return defaultValue;
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        if (this.contains(key, BinaryTagTypes.FLOAT)) {
            return ((NumberBinaryTag)this.tags.get(key)).floatValue();
        }
        return defaultValue;
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        if (this.contains(key, BinaryTagTypes.DOUBLE)) {
            return ((NumberBinaryTag)this.tags.get(key)).doubleValue();
        }
        return defaultValue;
    }

    @Override
    public byte[] getByteArray(String key) {
        if (this.contains(key, BinaryTagTypes.BYTE_ARRAY)) {
            return ((ByteArrayBinaryTag)this.tags.get(key)).value();
        }
        return new byte[0];
    }

    @Override
    public byte @Nullable [] getByteArray(String key, byte @Nullable [] defaultValue) {
        if (this.contains(key, BinaryTagTypes.BYTE_ARRAY)) {
            return ((ByteArrayBinaryTag)this.tags.get(key)).value();
        }
        return defaultValue;
    }

    @Override
    public @Nullable String getString(String key, @Nullable String defaultValue) {
        if (this.contains(key, BinaryTagTypes.STRING)) {
            return ((StringBinaryTag)this.tags.get(key)).value();
        }
        return defaultValue;
    }

    @Override
    public @Nullable ListBinaryTag getList(String key, @Nullable ListBinaryTag defaultValue) {
        if (this.contains(key, BinaryTagTypes.LIST)) {
            return (ListBinaryTag)this.tags.get(key);
        }
        return defaultValue;
    }

    @Override
    public @Nullable ListBinaryTag getList(String key, BinaryTagType<? extends BinaryTag> expectedType, @Nullable ListBinaryTag defaultValue) {
        ListBinaryTag tag;
        if (this.contains(key, BinaryTagTypes.LIST) && expectedType.test((BinaryTag)((Object)(tag = (ListBinaryTag)this.tags.get(key)).elementType()))) {
            return tag;
        }
        return defaultValue;
    }

    @Override
    public @Nullable CompoundBinaryTag getCompound(String key, @Nullable CompoundBinaryTag defaultValue) {
        if (this.contains(key, BinaryTagTypes.COMPOUND)) {
            return (CompoundBinaryTag)this.tags.get(key);
        }
        return defaultValue;
    }

    @Override
    public int[] getIntArray(String key) {
        if (this.contains(key, BinaryTagTypes.INT_ARRAY)) {
            return ((IntArrayBinaryTag)this.tags.get(key)).value();
        }
        return new int[0];
    }

    @Override
    public int @Nullable [] getIntArray(String key, int @Nullable [] defaultValue) {
        if (this.contains(key, BinaryTagTypes.INT_ARRAY)) {
            return ((IntArrayBinaryTag)this.tags.get(key)).value();
        }
        return defaultValue;
    }

    @Override
    public long[] getLongArray(String key) {
        if (this.contains(key, BinaryTagTypes.LONG_ARRAY)) {
            return ((LongArrayBinaryTag)this.tags.get(key)).value();
        }
        return new long[0];
    }

    @Override
    public long @Nullable [] getLongArray(String key, long @Nullable [] defaultValue) {
        if (this.contains(key, BinaryTagTypes.LONG_ARRAY)) {
            return ((LongArrayBinaryTag)this.tags.get(key)).value();
        }
        return defaultValue;
    }

    @Override
    public Stream<Map.Entry<String, ? extends BinaryTag>> stream() {
        return this.tags.entrySet().stream();
    }

    private CompoundBinaryTag edit(Consumer<Map<String, BinaryTag>> consumer) {
        HashMap<String, BinaryTag> tags = new HashMap<String, BinaryTag>(this.tags);
        consumer.accept(tags);
        return new CompoundBinaryTagImpl(new HashMap<String, BinaryTag>(tags));
    }

    @Override
    public Iterator<Map.Entry<String, ? extends BinaryTag>> iterator() {
        return this.tags.entrySet().iterator();
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, ? extends BinaryTag>> action) {
        this.tags.entrySet().forEach(Objects.requireNonNull(action, "action"));
    }
}

