/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import org.jspecify.annotations.Nullable;

public sealed interface CompoundTagSetter<R>
permits CompoundBinaryTag, CompoundBinaryTag.Builder {
    public R put(String var1, BinaryTag var2);

    public R put(CompoundBinaryTag var1);

    public R put(Map<String, ? extends BinaryTag> var1);

    default public R remove(String key) {
        return this.remove(key, null);
    }

    public R remove(String var1, @Nullable Consumer<? super BinaryTag> var2);

    default public R putBoolean(String key, boolean value) {
        return this.put(key, value ? ByteBinaryTag.ONE : ByteBinaryTag.ZERO);
    }

    default public R putByte(String key, byte value) {
        return this.put(key, ByteBinaryTag.byteBinaryTag(value));
    }

    default public R putShort(String key, short value) {
        return this.put(key, ShortBinaryTag.shortBinaryTag(value));
    }

    default public R putInt(String key, int value) {
        return this.put(key, IntBinaryTag.intBinaryTag(value));
    }

    default public R putLong(String key, long value) {
        return this.put(key, LongBinaryTag.longBinaryTag(value));
    }

    default public R putFloat(String key, float value) {
        return this.put(key, FloatBinaryTag.floatBinaryTag(value));
    }

    default public R putDouble(String key, double value) {
        return this.put(key, DoubleBinaryTag.doubleBinaryTag(value));
    }

    default public R putByteArray(String key, byte[] value) {
        return this.put(key, ByteArrayBinaryTag.byteArrayBinaryTag(value));
    }

    default public R putString(String key, String value) {
        return this.put(key, StringBinaryTag.stringBinaryTag(value));
    }

    default public R putIntArray(String key, int[] value) {
        return this.put(key, IntArrayBinaryTag.intArrayBinaryTag(value));
    }

    default public R putLongArray(String key, long[] value) {
        return this.put(key, LongArrayBinaryTag.longArrayBinaryTag(value));
    }
}

