/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import net.kyori.adventure.nbt.BinaryTagReaderImpl;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.BinaryTagWriterImpl;
import net.kyori.adventure.nbt.CompoundBinaryTag;

public final class BinaryTagIO {
    private BinaryTagIO() {
    }

    public static Reader unlimitedReader() {
        return BinaryTagReaderImpl.UNLIMITED;
    }

    public static Reader reader() {
        return BinaryTagReaderImpl.DEFAULT_LIMIT;
    }

    public static Reader reader(long sizeLimitBytes) {
        if (sizeLimitBytes <= 0L) {
            throw new IllegalArgumentException("The size limit must be greater than zero");
        }
        return new BinaryTagReaderImpl(sizeLimitBytes);
    }

    public static Writer writer() {
        return BinaryTagWriterImpl.INSTANCE;
    }

    static {
        BinaryTagTypes.COMPOUND.id();
    }

    public static interface Reader {
        default public CompoundBinaryTag read(Path path) throws IOException {
            return this.read(path, Compression.NONE);
        }

        public CompoundBinaryTag read(Path var1, Compression var2) throws IOException;

        default public CompoundBinaryTag read(InputStream input) throws IOException {
            return this.read(input, Compression.NONE);
        }

        public CompoundBinaryTag read(InputStream var1, Compression var2) throws IOException;

        public CompoundBinaryTag read(DataInput var1) throws IOException;

        default public CompoundBinaryTag readNameless(Path path) throws IOException {
            return this.readNameless(path, Compression.NONE);
        }

        public CompoundBinaryTag readNameless(Path var1, Compression var2) throws IOException;

        default public CompoundBinaryTag readNameless(InputStream input) throws IOException {
            return this.readNameless(input, Compression.NONE);
        }

        public CompoundBinaryTag readNameless(InputStream var1, Compression var2) throws IOException;

        public CompoundBinaryTag readNameless(DataInput var1) throws IOException;

        default public Map.Entry<String, CompoundBinaryTag> readNamed(Path path) throws IOException {
            return this.readNamed(path, Compression.NONE);
        }

        public Map.Entry<String, CompoundBinaryTag> readNamed(Path var1, Compression var2) throws IOException;

        default public Map.Entry<String, CompoundBinaryTag> readNamed(InputStream input) throws IOException {
            return this.readNamed(input, Compression.NONE);
        }

        public Map.Entry<String, CompoundBinaryTag> readNamed(InputStream var1, Compression var2) throws IOException;

        public Map.Entry<String, CompoundBinaryTag> readNamed(DataInput var1) throws IOException;
    }

    public static interface Writer {
        default public void write(CompoundBinaryTag tag, Path path) throws IOException {
            this.write(tag, path, Compression.NONE);
        }

        public void write(CompoundBinaryTag var1, Path var2, Compression var3) throws IOException;

        default public void write(CompoundBinaryTag tag, OutputStream output) throws IOException {
            this.write(tag, output, Compression.NONE);
        }

        public void write(CompoundBinaryTag var1, OutputStream var2, Compression var3) throws IOException;

        public void write(CompoundBinaryTag var1, DataOutput var2) throws IOException;

        default public void writeNameless(CompoundBinaryTag tag, Path path) throws IOException {
            this.writeNameless(tag, path, Compression.NONE);
        }

        public void writeNameless(CompoundBinaryTag var1, Path var2, Compression var3) throws IOException;

        default public void writeNameless(CompoundBinaryTag tag, OutputStream output) throws IOException {
            this.writeNameless(tag, output, Compression.NONE);
        }

        public void writeNameless(CompoundBinaryTag var1, OutputStream var2, Compression var3) throws IOException;

        public void writeNameless(CompoundBinaryTag var1, DataOutput var2) throws IOException;

        default public void writeNamed(Map.Entry<String, CompoundBinaryTag> tag, Path path) throws IOException {
            this.writeNamed(tag, path, Compression.NONE);
        }

        public void writeNamed(Map.Entry<String, CompoundBinaryTag> var1, Path var2, Compression var3) throws IOException;

        default public void writeNamed(Map.Entry<String, CompoundBinaryTag> tag, OutputStream output) throws IOException {
            this.writeNamed(tag, output, Compression.NONE);
        }

        public void writeNamed(Map.Entry<String, CompoundBinaryTag> var1, OutputStream var2, Compression var3) throws IOException;

        public void writeNamed(Map.Entry<String, CompoundBinaryTag> var1, DataOutput var2) throws IOException;
    }

    public static abstract class Compression {
        public static final Compression NONE = new Compression(){

            @Override
            InputStream decompress(InputStream is) {
                return is;
            }

            @Override
            OutputStream compress(OutputStream os) {
                return os;
            }

            public String toString() {
                return "Compression.NONE";
            }
        };
        public static final Compression GZIP = new Compression(){

            @Override
            InputStream decompress(InputStream is) throws IOException {
                return new GZIPInputStream(is);
            }

            @Override
            OutputStream compress(OutputStream os) throws IOException {
                return new GZIPOutputStream(os);
            }

            public String toString() {
                return "Compression.GZIP";
            }
        };
        public static final Compression ZLIB = new Compression(){

            @Override
            InputStream decompress(InputStream is) {
                return new InflaterInputStream(is);
            }

            @Override
            OutputStream compress(OutputStream os) {
                return new DeflaterOutputStream(os);
            }

            public String toString() {
                return "Compression.ZLIB";
            }
        };

        abstract InputStream decompress(InputStream var1) throws IOException;

        abstract OutputStream compress(OutputStream var1) throws IOException;
    }
}

