/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IOStreamUtil;

final class BinaryTagWriterImpl
implements BinaryTagIO.Writer {
    static final BinaryTagIO.Writer INSTANCE = new BinaryTagWriterImpl();

    private BinaryTagWriterImpl() {
    }

    @Override
    public void write(CompoundBinaryTag tag, Path path, BinaryTagIO.Compression compression) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.write(tag, os, compression);
        }
    }

    @Override
    public void write(CompoundBinaryTag tag, OutputStream output, BinaryTagIO.Compression compression) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(compression.compress(IOStreamUtil.closeShield(output))));){
            this.write(tag, dos);
        }
    }

    @Override
    public void write(CompoundBinaryTag tag, DataOutput output) throws IOException {
        this.write(tag, output, true);
    }

    private void write(CompoundBinaryTag tag, DataOutput output, boolean named) throws IOException {
        output.writeByte(BinaryTagTypes.COMPOUND.id());
        if (named) {
            output.writeUTF("");
        }
        BinaryTagTypes.COMPOUND.write(tag, output);
    }

    @Override
    public void writeNameless(CompoundBinaryTag tag, Path path, BinaryTagIO.Compression compression) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.writeNameless(tag, os, compression);
        }
    }

    @Override
    public void writeNameless(CompoundBinaryTag tag, OutputStream output, BinaryTagIO.Compression compression) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(compression.compress(IOStreamUtil.closeShield(output))));){
            this.writeNameless(tag, dos);
        }
    }

    @Override
    public void writeNameless(CompoundBinaryTag tag, DataOutput output) throws IOException {
        this.write(tag, output, false);
    }

    @Override
    public void writeNamed(Map.Entry<String, CompoundBinaryTag> tag, Path path, BinaryTagIO.Compression compression) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.writeNamed(tag, os, compression);
        }
    }

    @Override
    public void writeNamed(Map.Entry<String, CompoundBinaryTag> tag, OutputStream output, BinaryTagIO.Compression compression) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(compression.compress(IOStreamUtil.closeShield(output))));){
            this.writeNamed(tag, dos);
        }
    }

    @Override
    public void writeNamed(Map.Entry<String, CompoundBinaryTag> tag, DataOutput output) throws IOException {
        output.writeByte(BinaryTagTypes.COMPOUND.id());
        output.writeUTF(tag.getKey());
        BinaryTagTypes.COMPOUND.write(tag.getValue(), output);
    }
}

