/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ShadyPines;
import org.jetbrains.annotations.Debug;

@Debug.Renderer(text="\"byte[\" + this.value.length + \"]\"", childrenArray="this.value", hasChildren="this.value.length > 0")
record ByteArrayBinaryTagImpl(byte[] value) implements ByteArrayBinaryTag
{
    private final byte[] value;

    ByteArrayBinaryTagImpl(byte[] value) {
        this.value = Arrays.copyOf(value, value.length);
    }

    @Override
    public byte[] value() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public byte get(int index) {
        ShadyPines.checkIndex(index, this.value.length);
        return this.value[index];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] value(ByteArrayBinaryTag tag) {
        byte[] byArray;
        if (!(tag instanceof ByteArrayBinaryTagImpl)) {
            byArray = tag.value();
            return byArray;
        }
        ByteArrayBinaryTagImpl byteArrayBinaryTagImpl = (ByteArrayBinaryTagImpl)tag;
        try {
            byte[] byArray2;
            byte[] value1 = byArray2 = byteArrayBinaryTagImpl.value();
            byArray = value1;
            return byArray;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        byte[] value1;
        if (!(o instanceof ByteArrayBinaryTagImpl)) return false;
        ByteArrayBinaryTagImpl byteArrayBinaryTagImpl = (ByteArrayBinaryTagImpl)o;
        try {
            byte[] byArray;
            value1 = byArray = byteArrayBinaryTagImpl.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Objects.deepEquals(this.value, value1);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public String toString() {
        return "ByteArrayBinaryTagImpl{value=" + Arrays.toString(this.value) + "}";
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ByteArrayBinaryTagImpl.this.value.length - 1;
            }

            @Override
            public Byte next() {
                return ByteArrayBinaryTagImpl.this.value[this.index++];
            }
        };
    }
}

