/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTagImpl;
import net.kyori.adventure.nbt.CompoundTagBuilder;
import net.kyori.adventure.nbt.CompoundTagSetter;
import net.kyori.adventure.nbt.ListBinaryTag;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

public sealed interface CompoundBinaryTag
extends BinaryTag,
CompoundTagSetter<CompoundBinaryTag>,
Iterable<Map.Entry<String, ? extends BinaryTag>>
permits CompoundBinaryTagImpl {
    public static CompoundBinaryTag empty() {
        return CompoundBinaryTagImpl.EMPTY;
    }

    public static CompoundBinaryTag from(Map<String, ? extends BinaryTag> tags) {
        if (tags.isEmpty()) {
            return CompoundBinaryTag.empty();
        }
        return new CompoundBinaryTagImpl(new HashMap<String, BinaryTag>(tags));
    }

    public static Collector<Map.Entry<String, ? extends BinaryTag>, ?, CompoundBinaryTag> toCompoundTag() {
        return CompoundBinaryTag.toCompoundTag(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Collector<T, ?, CompoundBinaryTag> toCompoundTag(Function<T, String> keyLens, Function<T, ? extends BinaryTag> valueLens) {
        Objects.requireNonNull(keyLens, "keyLens");
        Objects.requireNonNull(valueLens, "valueLens");
        return Collector.of(CompoundBinaryTag::builder, (b, ent) -> b.put((String)keyLens.apply(ent), (BinaryTag)valueLens.apply(ent)), (l, r) -> (Builder)l.put(r.build()), Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static Collector<Map.Entry<String, ? extends BinaryTag>, ?, CompoundBinaryTag> toCompoundTag(CompoundBinaryTag initial) {
        return CompoundBinaryTag.toCompoundTag(initial, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Collector<T, ?, CompoundBinaryTag> toCompoundTag(CompoundBinaryTag initial, Function<T, String> keyLens, Function<T, ? extends BinaryTag> valueLens) {
        Objects.requireNonNull(initial, "initial");
        Objects.requireNonNull(keyLens, "keyLens");
        Objects.requireNonNull(valueLens, "valueLens");
        return Collector.of(() -> (Builder)CompoundBinaryTag.builder().put(initial), (b, ent) -> b.put((String)keyLens.apply(ent), (BinaryTag)valueLens.apply(ent)), (l, r) -> (Builder)l.put(r.build()), Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static Builder builder() {
        return new CompoundTagBuilder();
    }

    public static Builder builder(@Range(from=0L, to=0x7FFFFFFFL) int initialCapacity) {
        return new CompoundTagBuilder(initialCapacity);
    }

    default public BinaryTagType<CompoundBinaryTag> type() {
        return BinaryTagTypes.COMPOUND;
    }

    public boolean contains(String var1);

    public boolean contains(String var1, BinaryTagType<?> var2);

    public Set<String> keySet();

    public @Nullable BinaryTag get(String var1);

    public int size();

    public boolean isEmpty();

    default public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    default public boolean getBoolean(String key, boolean defaultValue) {
        BinaryTag tag = this.get(key);
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag bbt = (ByteBinaryTag)tag;
            return bbt.value() != 0;
        }
        return defaultValue;
    }

    default public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String var1, byte var2);

    default public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String var1, short var2);

    default public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String var1, int var2);

    default public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String var1, long var2);

    default public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String var1, float var2);

    default public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String var1, double var2);

    public byte[] getByteArray(String var1);

    @Contract(value="_, !null -> !null")
    public byte @Nullable [] getByteArray(String var1, byte @Nullable [] var2);

    default public String getString(String key) {
        return this.getString(key, "");
    }

    @Contract(value="_, !null -> !null")
    public @Nullable String getString(String var1, @Nullable String var2);

    default public ListBinaryTag getList(String key) {
        return this.getList(key, ListBinaryTag.empty());
    }

    @Contract(value="_, !null -> !null")
    public @Nullable ListBinaryTag getList(String var1, @Nullable ListBinaryTag var2);

    default public ListBinaryTag getList(String key, BinaryTagType<? extends BinaryTag> expectedType) {
        return this.getList(key, expectedType, ListBinaryTag.empty());
    }

    @Contract(value="_, _, !null -> !null")
    public @Nullable ListBinaryTag getList(String var1, BinaryTagType<? extends BinaryTag> var2, @Nullable ListBinaryTag var3);

    default public CompoundBinaryTag getCompound(String key) {
        return this.getCompound(key, CompoundBinaryTag.empty());
    }

    @Contract(value="_, !null -> !null")
    public @Nullable CompoundBinaryTag getCompound(String var1, @Nullable CompoundBinaryTag var2);

    public int[] getIntArray(String var1);

    @Contract(value="_, !null -> !null")
    public int @Nullable [] getIntArray(String var1, int @Nullable [] var2);

    public long[] getLongArray(String var1);

    @Contract(value="_, !null -> !null")
    public long @Nullable [] getLongArray(String var1, long @Nullable [] var2);

    public Stream<Map.Entry<String, ? extends BinaryTag>> stream();

    public static sealed interface Builder
    extends CompoundTagSetter<Builder>
    permits CompoundTagBuilder {
        public CompoundBinaryTag build();
    }
}

