/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTagImpl;
import org.jspecify.annotations.Nullable;

final class CompoundTagBuilder
implements CompoundBinaryTag.Builder {
    private static final int DEFAULT_CAPACITY = -1;
    private @Nullable Map<String, BinaryTag> tags;
    private final int initialCapacity;

    CompoundTagBuilder() {
        this(-1);
    }

    CompoundTagBuilder(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    private Map<String, BinaryTag> tags() {
        if (this.tags == null) {
            if (this.initialCapacity != -1) {
                if (this.initialCapacity < 0) {
                    throw new IllegalArgumentException("initialCapacity cannot be less than 0, was " + this.initialCapacity);
                }
                this.tags = new HashMap<String, BinaryTag>(this.initialCapacity);
            } else {
                this.tags = new HashMap<String, BinaryTag>();
            }
        }
        return this.tags;
    }

    @Override
    public CompoundBinaryTag.Builder put(String key, BinaryTag tag) {
        this.tags().put(key, tag);
        return this;
    }

    @Override
    public CompoundBinaryTag.Builder put(CompoundBinaryTag tag) {
        Map<String, BinaryTag> tags = this.tags();
        for (String key : tag.keySet()) {
            tags.put(key, tag.get(key));
        }
        return this;
    }

    @Override
    public CompoundBinaryTag.Builder put(Map<String, ? extends BinaryTag> tags) {
        this.tags().putAll(tags);
        return this;
    }

    @Override
    public CompoundBinaryTag.Builder remove(String key, @Nullable Consumer<? super BinaryTag> removed) {
        if (this.tags != null) {
            BinaryTag tag = this.tags.remove(key);
            if (removed != null) {
                removed.accept(tag);
            }
        }
        return this;
    }

    @Override
    public CompoundBinaryTag build() {
        if (this.tags == null) {
            return CompoundBinaryTag.empty();
        }
        return new CompoundBinaryTagImpl(new HashMap<String, BinaryTag>(this.tags));
    }
}

