/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.ShadyPines;
import org.jetbrains.annotations.Debug;

@Debug.Renderer(text="\"int[\" + this.value.length + \"]\"", childrenArray="this.value", hasChildren="this.value.length > 0")
record IntArrayBinaryTagImpl(int[] value) implements IntArrayBinaryTag
{
    private final int[] value;

    IntArrayBinaryTagImpl(int ... value) {
        this.value = Arrays.copyOf(value, value.length);
    }

    @Override
    public int[] value() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public int get(int index) {
        ShadyPines.checkIndex(index, this.value.length);
        return this.value[index];
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return new PrimitiveIterator.OfInt(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < IntArrayBinaryTagImpl.this.value.length - 1;
            }

            @Override
            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IntArrayBinaryTagImpl.this.value[this.index++];
            }
        };
    }

    @Override
    public Spliterator.OfInt spliterator() {
        return Arrays.spliterator(this.value);
    }

    @Override
    public IntStream stream() {
        return Arrays.stream(this.value);
    }

    @Override
    public void forEachInt(IntConsumer action) {
        for (int j : this.value) {
            action.accept(j);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        int[] value1;
        if (!(o instanceof IntArrayBinaryTagImpl)) return false;
        IntArrayBinaryTagImpl intArrayBinaryTagImpl = (IntArrayBinaryTagImpl)o;
        try {
            int[] nArray;
            value1 = nArray = intArrayBinaryTagImpl.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Objects.deepEquals(this.value, value1);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public String toString() {
        return "IntArrayBinaryTagImpl{value=" + Arrays.toString(this.value) + "}";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int[] value(IntArrayBinaryTag tag) {
        int[] nArray;
        if (!(tag instanceof IntArrayBinaryTagImpl)) {
            nArray = tag.value();
            return nArray;
        }
        IntArrayBinaryTagImpl intArrayBinaryTagImpl = (IntArrayBinaryTagImpl)tag;
        try {
            int[] nArray2;
            int[] value1 = nArray2 = intArrayBinaryTagImpl.value();
            nArray = value1;
            return nArray;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

