/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.ShadyPines;
import org.jetbrains.annotations.Debug;

@Debug.Renderer(text="\"long[\" + this.value.length + \"]\"", childrenArray="this.value", hasChildren="this.value.length > 0")
record LongArrayBinaryTagImpl(long[] value) implements LongArrayBinaryTag
{
    private final long[] value;

    LongArrayBinaryTagImpl(long[] value) {
        this.value = Arrays.copyOf(value, value.length);
    }

    @Override
    public long[] value() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public long get(int index) {
        ShadyPines.checkIndex(index, this.value.length);
        return this.value[index];
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return new PrimitiveIterator.OfLong(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < LongArrayBinaryTagImpl.this.value.length - 1;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LongArrayBinaryTagImpl.this.value[this.index++];
            }
        };
    }

    @Override
    public Spliterator.OfLong spliterator() {
        return Arrays.spliterator(this.value);
    }

    @Override
    public LongStream stream() {
        return Arrays.stream(this.value);
    }

    @Override
    public void forEachLong(LongConsumer action) {
        for (long l : this.value) {
            action.accept(l);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        long[] value1;
        if (!(o instanceof LongArrayBinaryTagImpl)) return false;
        LongArrayBinaryTagImpl longArrayBinaryTagImpl = (LongArrayBinaryTagImpl)o;
        try {
            long[] lArray;
            value1 = lArray = longArrayBinaryTagImpl.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Objects.deepEquals(this.value, value1);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public String toString() {
        return "LongArrayBinaryTagImpl{value=" + Arrays.toString(this.value) + "}";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long[] value(LongArrayBinaryTag tag) {
        long[] lArray;
        if (!(tag instanceof LongArrayBinaryTagImpl)) {
            lArray = tag.value();
            return lArray;
        }
        LongArrayBinaryTagImpl longArrayBinaryTagImpl = (LongArrayBinaryTagImpl)tag;
        try {
            long[] lArray2;
            long[] value1 = lArray2 = longArrayBinaryTagImpl.value();
            lArray = value1;
            return lArray;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

