/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.io.IOException;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTagImpl;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTagImpl;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTagImpl;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.nbt.Tokens;

final class TagStringWriter
implements AutoCloseable {
    private final Appendable out;
    private final String indent;
    private int level;
    private boolean needsSeparator;
    private boolean legacy;
    private boolean heterogeneousLists;

    TagStringWriter(Appendable out, String indent) {
        this.out = out;
        this.indent = indent;
    }

    public TagStringWriter legacy(boolean legacy) {
        this.legacy = legacy;
        return this;
    }

    public TagStringWriter heterogeneousLists(boolean emitHeterogeneousLists) {
        this.heterogeneousLists = emitHeterogeneousLists;
        return this;
    }

    public TagStringWriter writeTag(BinaryTag tag) throws IOException {
        BinaryTag binaryTag = tag;
        Objects.requireNonNull(binaryTag);
        BinaryTag binaryTag2 = binaryTag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompoundBinaryTag.class, ListBinaryTag.class, ByteArrayBinaryTag.class, IntArrayBinaryTag.class, LongArrayBinaryTag.class, StringBinaryTag.class, ByteBinaryTag.class, ShortBinaryTag.class, IntBinaryTag.class, LongBinaryTag.class, FloatBinaryTag.class, DoubleBinaryTag.class}, (Object)binaryTag2, n)) {
            case 0 -> {
                CompoundBinaryTag compoundTag = (CompoundBinaryTag)binaryTag2;
                yield this.writeCompound(compoundTag);
            }
            case 1 -> {
                ListBinaryTag listTag = (ListBinaryTag)binaryTag2;
                yield this.writeList(listTag);
            }
            case 2 -> {
                ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)binaryTag2;
                yield this.writeByteArray(byteArrayTag);
            }
            case 3 -> {
                IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)binaryTag2;
                yield this.writeIntArray(intArrayTag);
            }
            case 4 -> {
                LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)binaryTag2;
                yield this.writeLongArray(longArrayTag);
            }
            case 5 -> {
                StringBinaryTag stringTag = (StringBinaryTag)binaryTag2;
                yield this.value(stringTag.value(), '\u0000');
            }
            case 6 -> {
                ByteBinaryTag byteTag = (ByteBinaryTag)binaryTag2;
                yield this.value(Byte.toString(byteTag.value()), 'b');
            }
            case 7 -> {
                ShortBinaryTag shortTag = (ShortBinaryTag)binaryTag2;
                yield this.value(Short.toString(shortTag.value()), 's');
            }
            case 8 -> {
                IntBinaryTag intTag = (IntBinaryTag)binaryTag2;
                yield this.value(Integer.toString(intTag.value()), 'i');
            }
            case 9 -> {
                LongBinaryTag longTag = (LongBinaryTag)binaryTag2;
                yield this.value(Long.toString(longTag.value()), Character.toUpperCase('l'));
            }
            case 10 -> {
                FloatBinaryTag floatTag = (FloatBinaryTag)binaryTag2;
                yield this.value(Float.toString(floatTag.value()), 'f');
            }
            case 11 -> {
                DoubleBinaryTag doubleTag = (DoubleBinaryTag)binaryTag2;
                yield this.value(Double.toString(doubleTag.value()), 'd');
            }
            default -> throw new IOException("Unknown tag type: " + String.valueOf(tag.type()));
        };
    }

    private TagStringWriter writeCompound(CompoundBinaryTag tag) throws IOException {
        this.beginCompound();
        for (Map.Entry entry : tag) {
            this.key((String)entry.getKey());
            this.writeTag((BinaryTag)entry.getValue());
        }
        this.endCompound();
        return this;
    }

    private TagStringWriter writeList(ListBinaryTag rawTag) throws IOException {
        ListBinaryTag tag = this.heterogeneousLists ? rawTag.unwrapHeterogeneity() : rawTag.wrapHeterogeneity();
        this.beginList();
        int idx = 0;
        boolean lineBreaks = this.prettyPrinting() && this.breakListElement(tag.elementType());
        for (BinaryTag el : tag) {
            this.printAndResetSeparator(!lineBreaks);
            if (lineBreaks) {
                this.newlineIndent();
            }
            if (this.legacy) {
                this.out.append(String.valueOf(idx++));
                this.appendSeparator(':');
            }
            this.writeTag(el);
        }
        this.endList(lineBreaks);
        return this;
    }

    private TagStringWriter writeByteArray(ByteArrayBinaryTag tag) throws IOException {
        byte[] value;
        if (this.legacy) {
            throw new IOException("Legacy Mojangson only supports integer arrays!");
        }
        this.beginArray('b');
        char byteArrayType = Character.toUpperCase('b');
        for (byte b : value = ByteArrayBinaryTagImpl.value(tag)) {
            this.printAndResetSeparator(true);
            this.value(Byte.toString(b), byteArrayType);
        }
        this.endArray();
        return this;
    }

    private TagStringWriter writeIntArray(IntArrayBinaryTag tag) throws IOException {
        int[] value;
        if (this.legacy) {
            this.beginList();
        } else {
            this.beginArray('i');
        }
        for (int j : value = IntArrayBinaryTagImpl.value(tag)) {
            this.printAndResetSeparator(true);
            this.value(Integer.toString(j), 'i');
        }
        this.endArray();
        return this;
    }

    private TagStringWriter writeLongArray(LongArrayBinaryTag tag) throws IOException {
        long[] value;
        if (this.legacy) {
            throw new IOException("Legacy Mojangson only supports integer arrays!");
        }
        this.beginArray('l');
        for (long l : value = LongArrayBinaryTagImpl.value(tag)) {
            this.printAndResetSeparator(true);
            this.value(Long.toString(l), 'l');
        }
        this.endArray();
        return this;
    }

    public TagStringWriter beginCompound() throws IOException {
        this.printAndResetSeparator(false);
        ++this.level;
        this.out.append('{');
        return this;
    }

    public TagStringWriter endCompound() throws IOException {
        --this.level;
        this.newlineIndent();
        this.out.append('}');
        this.needsSeparator = true;
        return this;
    }

    public TagStringWriter key(String key) throws IOException {
        this.printAndResetSeparator(false);
        this.newlineIndent();
        this.writeMaybeQuoted(key, false);
        this.appendSeparator(':');
        return this;
    }

    public TagStringWriter value(String value, char valueType) throws IOException {
        if (valueType == '\u0000') {
            this.writeMaybeQuoted(value, true);
        } else {
            this.out.append(value);
            if (valueType != 'i') {
                this.out.append(valueType);
            }
        }
        this.needsSeparator = true;
        return this;
    }

    public TagStringWriter beginList() throws IOException {
        this.printAndResetSeparator(false);
        ++this.level;
        this.out.append('[');
        return this;
    }

    public TagStringWriter endList(boolean lineBreak) throws IOException {
        --this.level;
        if (lineBreak) {
            this.newlineIndent();
        }
        this.out.append(']');
        this.needsSeparator = true;
        return this;
    }

    private TagStringWriter beginArray(char type) throws IOException {
        this.beginList().out.append(Character.toUpperCase(type)).append(';');
        if (this.prettyPrinting()) {
            this.out.append(' ');
        }
        return this;
    }

    private TagStringWriter endArray() throws IOException {
        return this.endList(false);
    }

    private void writeMaybeQuoted(String content, boolean requireQuotes) throws IOException {
        if (!requireQuotes) {
            for (int i = 0; i < content.length(); ++i) {
                if (Tokens.id(content.charAt(i))) continue;
                requireQuotes = true;
                break;
            }
        }
        if (requireQuotes) {
            this.out.append('\"');
            this.out.append(TagStringWriter.escape(content, '\"'));
            this.out.append('\"');
        } else {
            this.out.append(content);
        }
    }

    private static String escape(String content, char quoteChar) {
        StringBuilder output = new StringBuilder(content.length());
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == quoteChar || c == '\\') {
                output.append('\\');
            }
            output.append(c);
        }
        return output.toString();
    }

    private void printAndResetSeparator(boolean pad) throws IOException {
        if (this.needsSeparator) {
            this.out.append(',');
            if (pad && this.prettyPrinting()) {
                this.out.append(' ');
            }
            this.needsSeparator = false;
        }
    }

    private boolean breakListElement(BinaryTagType<?> type) {
        return type == BinaryTagTypes.COMPOUND || type == BinaryTagTypes.LIST || type == BinaryTagTypes.BYTE_ARRAY || type == BinaryTagTypes.INT_ARRAY || type == BinaryTagTypes.LONG_ARRAY;
    }

    private boolean prettyPrinting() {
        return !this.indent.isEmpty();
    }

    private void newlineIndent() throws IOException {
        if (this.prettyPrinting()) {
            this.out.append(Tokens.NEWLINE);
            for (int i = 0; i < this.level; ++i) {
                this.out.append(this.indent);
            }
        }
    }

    private Appendable appendSeparator(char separatorChar) throws IOException {
        this.out.append(separatorChar);
        if (this.prettyPrinting()) {
            this.out.append(' ');
        }
        return this.out;
    }

    @Override
    public void close() throws IOException {
        if (this.level != 0) {
            throw new IllegalStateException("Document finished with unbalanced start and end objects");
        }
        Appendable appendable = this.out;
        if (appendable instanceof Writer) {
            Writer writer = (Writer)appendable;
            writer.flush();
        }
    }
}

