/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.ContextImpl;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.MiniMessageParser;
import net.kyori.adventure.text.minimessage.MiniMessageSerializer;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tree.Node;
import net.kyori.adventure.util.Services;
import org.jspecify.annotations.Nullable;

record MiniMessageImpl(MiniMessageParser parser, boolean strict, boolean emitVirtuals, @Nullable Consumer<String> debugOutput, UnaryOperator<String> preProcessor, UnaryOperator<Component> postProcessor) implements MiniMessage
{
    private static final Optional<MiniMessage.Provider> SERVICE = Services.service(MiniMessage.Provider.class);
    static final Consumer<MiniMessage.Builder> BUILDER = SERVICE.map(MiniMessage.Provider::builder).orElseGet(() -> builder -> {});
    static final UnaryOperator<String> DEFAULT_NO_OP = UnaryOperator.identity();
    static final UnaryOperator<Component> DEFAULT_COMPACTING_METHOD = Component::compact;

    MiniMessageImpl(TagResolver parser, boolean strict, boolean emitVirtuals, @Nullable Consumer<String> debugOutput, UnaryOperator<String> preProcessor, UnaryOperator<Component> postProcessor) {
        this(new MiniMessageParser(parser), strict, emitVirtuals, debugOutput, preProcessor, postProcessor);
    }

    public Component deserialize(String input) {
        return this.parser.parseFormat(this.newContext(input, null, null));
    }

    @Override
    public Component deserialize(String input, Pointered target) {
        return this.parser.parseFormat(this.newContext(input, Objects.requireNonNull(target, "target"), null));
    }

    @Override
    public Component deserialize(String input, TagResolver tagResolver) {
        return this.parser.parseFormat(this.newContext(input, null, Objects.requireNonNull(tagResolver, "tagResolver")));
    }

    @Override
    public Component deserialize(String input, Pointered target, TagResolver tagResolver) {
        return this.parser.parseFormat(this.newContext(input, Objects.requireNonNull(target, "target"), Objects.requireNonNull(tagResolver, "tagResolver")));
    }

    @Override
    public Node.Root deserializeToTree(String input) {
        return this.parser.parseToTree(this.newContext(input, null, null));
    }

    @Override
    public Node.Root deserializeToTree(String input, Pointered target) {
        return this.parser.parseToTree(this.newContext(input, Objects.requireNonNull(target, "target"), null));
    }

    @Override
    public Node.Root deserializeToTree(String input, TagResolver tagResolver) {
        return this.parser.parseToTree(this.newContext(input, null, Objects.requireNonNull(tagResolver, "tagResolver")));
    }

    @Override
    public Node.Root deserializeToTree(String input, Pointered target, TagResolver tagResolver) {
        return this.parser.parseToTree(this.newContext(input, Objects.requireNonNull(target, "target"), Objects.requireNonNull(tagResolver, "tagResolver")));
    }

    public String serialize(Component component) {
        return MiniMessageSerializer.serialize(component, this.serialResolver(null), this.strict);
    }

    private SerializableResolver serialResolver(@Nullable TagResolver extraResolver) {
        if (extraResolver == null) {
            if (this.parser.tagResolver() instanceof SerializableResolver) {
                return (SerializableResolver)((Object)this.parser.tagResolver());
            }
        } else {
            TagResolver combined = TagResolver.resolver(this.parser.tagResolver(), extraResolver);
            if (combined instanceof SerializableResolver) {
                SerializableResolver serializableResolver = (SerializableResolver)((Object)combined);
                return serializableResolver;
            }
        }
        return (SerializableResolver)((Object)TagResolver.empty());
    }

    @Override
    public String escapeTags(String input) {
        return this.parser.escapeTokens(this.newContext(input, null, null));
    }

    @Override
    public String escapeTags(String input, TagResolver tagResolver) {
        return this.parser.escapeTokens(this.newContext(input, null, tagResolver));
    }

    @Override
    public String stripTags(String input) {
        return this.parser.stripTokens(this.newContext(input, null, null));
    }

    @Override
    public String stripTags(String input, TagResolver tagResolver) {
        return this.parser.stripTokens(this.newContext(input, null, tagResolver));
    }

    @Override
    public TagResolver tags() {
        return this.parser.tagResolver();
    }

    private ContextImpl newContext(String input, @Nullable Pointered target, @Nullable TagResolver resolver) {
        Objects.requireNonNull(input, "input");
        return new ContextImpl(this.strict, this.emitVirtuals, this.debugOutput, input, this, target, resolver, this.preProcessor, this.postProcessor);
    }

    static final class BuilderImpl
    implements MiniMessage.Builder {
        private TagResolver tagResolver = TagResolver.standard();
        private boolean strict = false;
        private boolean emitVirtuals = true;
        private @Nullable Consumer<String> debug = null;
        private UnaryOperator<Component> postProcessor = DEFAULT_COMPACTING_METHOD;
        private UnaryOperator<String> preProcessor = DEFAULT_NO_OP;

        BuilderImpl() {
            BUILDER.accept(this);
        }

        BuilderImpl(MiniMessageImpl serializer) {
            this();
            this.tagResolver = serializer.parser.tagResolver();
            this.strict = serializer.strict;
            this.debug = serializer.debugOutput;
            this.postProcessor = serializer.postProcessor;
            this.preProcessor = serializer.preProcessor;
        }

        @Override
        public MiniMessage.Builder tags(TagResolver tags) {
            this.tagResolver = Objects.requireNonNull(tags, "tags");
            return this;
        }

        @Override
        public MiniMessage.Builder editTags(Consumer<TagResolver.Builder> adder) {
            Objects.requireNonNull(adder, "adder");
            TagResolver.Builder builder = TagResolver.builder().resolver(this.tagResolver);
            adder.accept(builder);
            this.tagResolver = builder.build();
            return this;
        }

        @Override
        public MiniMessage.Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        @Override
        public MiniMessage.Builder emitVirtuals(boolean emitVirtuals) {
            this.emitVirtuals = emitVirtuals;
            return this;
        }

        @Override
        public MiniMessage.Builder debug(@Nullable Consumer<String> debugOutput) {
            this.debug = debugOutput;
            return this;
        }

        @Override
        public MiniMessage.Builder postProcessor(UnaryOperator<Component> postProcessor) {
            this.postProcessor = Objects.requireNonNull(postProcessor, "postProcessor");
            return this;
        }

        @Override
        public MiniMessage.Builder preProcessor(UnaryOperator<String> preProcessor) {
            this.preProcessor = Objects.requireNonNull(preProcessor, "preProcessor");
            return this;
        }

        @Override
        public MiniMessage build() {
            return new MiniMessageImpl(this.tagResolver, this.strict, this.emitVirtuals, this.debug, this.preProcessor, this.postProcessor);
        }
    }

    static final class Instances {
        static final MiniMessage INSTANCE = SERVICE.map(MiniMessage.Provider::miniMessage).orElseGet(() -> new MiniMessageImpl(TagResolver.standard(), false, true, null, DEFAULT_NO_OP, DEFAULT_COMPACTING_METHOD));

        Instances() {
        }
    }
}

