/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.internal.parser.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.minimessage.internal.parser.Token;
import net.kyori.adventure.text.minimessage.internal.parser.TokenType;
import net.kyori.adventure.text.minimessage.internal.parser.node.RootNode;
import net.kyori.adventure.text.minimessage.internal.parser.node.TagNode;
import net.kyori.adventure.text.minimessage.internal.parser.node.TextNode;
import net.kyori.adventure.text.minimessage.internal.parser.node.ValueNode;
import net.kyori.adventure.text.minimessage.tree.Node;
import org.jspecify.annotations.Nullable;

public sealed class ElementNode
implements Node
permits RootNode, TagNode, ValueNode {
    private final @Nullable ElementNode parent;
    private final @Nullable Token token;
    private final String sourceMessage;
    private final List<ElementNode> children = new ArrayList<ElementNode>();

    ElementNode(@Nullable ElementNode parent, @Nullable Token token, String sourceMessage) {
        this.parent = parent;
        this.token = token;
        this.sourceMessage = sourceMessage;
    }

    @Override
    public @Nullable ElementNode parent() {
        return this.parent;
    }

    public @Nullable Token token() {
        return this.token;
    }

    public String sourceMessage() {
        return this.sourceMessage;
    }

    public List<ElementNode> children() {
        return List.copyOf(this.children);
    }

    public List<ElementNode> unsafeChildren() {
        return this.children;
    }

    public void addChild(ElementNode childNode) {
        int last = this.children.size() - 1;
        if (!(childNode instanceof TextNode) || this.children.isEmpty() || !(this.children.get(last) instanceof TextNode)) {
            this.children.add(childNode);
        } else {
            TextNode lastNode = (TextNode)this.children.remove(last);
            if (lastNode.token().endIndex() == childNode.token().startIndex()) {
                Token replace = new Token(lastNode.token().startIndex(), childNode.token().endIndex(), TokenType.TEXT);
                this.children.add(new TextNode(this, replace, lastNode.sourceMessage()));
            } else {
                this.children.add(lastNode);
                this.children.add(childNode);
            }
        }
    }

    public StringBuilder buildToString(StringBuilder sb, int indent) {
        char[] in = this.ident(indent);
        sb.append(in).append("Node {\n");
        for (ElementNode child : this.children) {
            child.buildToString(sb, indent + 1);
        }
        sb.append(in).append("}\n");
        return sb;
    }

    char[] ident(int indent) {
        char[] c = new char[indent * 2];
        Arrays.fill(c, ' ');
        return c;
    }

    @Override
    public String toString() {
        return this.buildToString(new StringBuilder(), 0).toString();
    }
}

