/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.internal.parser.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.internal.parser.ParsingExceptionImpl;
import net.kyori.adventure.text.minimessage.internal.parser.Token;
import net.kyori.adventure.text.minimessage.internal.parser.TokenParser;
import net.kyori.adventure.text.minimessage.internal.parser.node.ElementNode;
import net.kyori.adventure.text.minimessage.internal.parser.node.TagPart;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.jspecify.annotations.Nullable;

public final class TagNode
extends ElementNode {
    private final List<TagPart> parts;
    private @Nullable Tag tag = null;

    public TagNode(ElementNode parent, Token token, String sourceMessage, TokenParser.TagProvider tagProvider) {
        super(parent, token, sourceMessage);
        this.parts = TagNode.genParts(token, sourceMessage, tagProvider);
        if (this.parts.isEmpty()) {
            throw new ParsingExceptionImpl("Tag has no parts? " + String.valueOf(this), this.sourceMessage(), this.token());
        }
    }

    private static List<TagPart> genParts(Token token, String sourceMessage, TokenParser.TagProvider tagProvider) {
        ArrayList<TagPart> parts = new ArrayList<TagPart>();
        if (token.childTokens() != null) {
            for (Token childToken : token.childTokens()) {
                parts.add(new TagPart(sourceMessage, childToken, tagProvider));
            }
        }
        return parts;
    }

    public List<TagPart> parts() {
        return this.parts;
    }

    public String name() {
        return this.parts.getFirst().value();
    }

    @Override
    public Token token() {
        return Objects.requireNonNull(super.token(), "token is not set");
    }

    public Tag tag() {
        return Objects.requireNonNull(this.tag, "no tag set");
    }

    public void tag(Tag tag) {
        this.tag = tag;
    }

    @Override
    public StringBuilder buildToString(StringBuilder sb, int indent) {
        char[] in = this.ident(indent);
        sb.append(in).append("TagNode(");
        int size = this.parts.size();
        for (int i = 0; i < size; ++i) {
            TagPart part = this.parts.get(i);
            sb.append('\'').append(part.value()).append('\'');
            if (i == size - 1) continue;
            sb.append(", ");
        }
        sb.append(") {\n");
        for (ElementNode child : this.children()) {
            child.buildToString(sb, indent + 1);
        }
        sb.append(in).append("}\n");
        return sb;
    }
}

