/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.minimessage.internal.parser.node.TagPart;
import net.kyori.adventure.text.minimessage.tag.CallbackStylingTagImpl;
import net.kyori.adventure.text.minimessage.tag.Inserting;
import net.kyori.adventure.text.minimessage.tag.InsertingImpl;
import net.kyori.adventure.text.minimessage.tag.Modifying;
import net.kyori.adventure.text.minimessage.tag.ParserDirective;
import net.kyori.adventure.text.minimessage.tag.PreProcess;
import net.kyori.adventure.text.minimessage.tag.PreProcessTagImpl;
import net.kyori.adventure.text.minimessage.tag.StylingTagImpl;

public sealed interface Tag
permits Inserting, Modifying, ParserDirective, PreProcess {
    public static PreProcess preProcessParsed(String content) {
        return new PreProcessTagImpl(Objects.requireNonNull(content, "content"));
    }

    public static Tag inserting(Component content) {
        return new InsertingImpl(true, Objects.requireNonNull(content, "content must not be null"));
    }

    public static Tag inserting(ComponentLike value) {
        return Tag.inserting(Objects.requireNonNull(value, "value").asComponent());
    }

    public static Tag selfClosingInserting(Component content) {
        return new InsertingImpl(false, Objects.requireNonNull(content, "content must not be null"));
    }

    public static Tag selfClosingInserting(ComponentLike value) {
        return Tag.selfClosingInserting(Objects.requireNonNull(value, "value").asComponent());
    }

    public static Tag styling(Consumer<Style.Builder> styles) {
        return new CallbackStylingTagImpl(styles);
    }

    public static Tag styling(StyleBuilderApplicable ... actions) {
        Objects.requireNonNull(actions, "actions");
        int length = actions.length;
        for (int i = 0; i < length; ++i) {
            if (actions[i] != null) continue;
            throw new NullPointerException("actions[" + i + "]");
        }
        return new StylingTagImpl(Arrays.copyOf(actions, actions.length));
    }

    public static sealed interface Argument
    permits TagPart {
        public String value();

        default public String lowerValue() {
            return this.value().toLowerCase(Locale.ROOT);
        }

        default public boolean isTrue() {
            return "true".equals(this.value()) || "on".equals(this.value());
        }

        default public boolean isFalse() {
            return "false".equals(this.value()) || "off".equals(this.value());
        }

        default public OptionalInt asInt() {
            try {
                return OptionalInt.of(Integer.parseInt(this.value()));
            }
            catch (NumberFormatException ex) {
                return OptionalInt.empty();
            }
        }

        default public OptionalDouble asDouble() {
            try {
                return OptionalDouble.of(Double.parseDouble(this.value()));
            }
            catch (NumberFormatException ex) {
                return OptionalDouble.empty();
            }
        }
    }
}

