/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.internal.serializer.ClaimConsumer;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.MappableResolver;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jspecify.annotations.Nullable;

final class CachingTagResolver
implements TagResolver.WithoutArguments,
MappableResolver,
SerializableResolver {
    private static final Tag NULL_REPLACEMENT = () -> {
        throw new UnsupportedOperationException("no-op null tag");
    };
    private final Map<String, Tag> cache = new HashMap<String, Tag>();
    private final TagResolver.WithoutArguments resolver;

    CachingTagResolver(TagResolver.WithoutArguments resolver) {
        this.resolver = resolver;
    }

    private Tag query(String key) {
        return this.cache.computeIfAbsent(key, k -> {
            Tag result = this.resolver.resolve((String)k);
            return result == null ? NULL_REPLACEMENT : result;
        });
    }

    @Override
    public @Nullable Tag resolve(String name) {
        Tag potentialValue = this.query(name);
        return potentialValue == NULL_REPLACEMENT ? null : potentialValue;
    }

    @Override
    public boolean has(String name) {
        return this.query(name) != NULL_REPLACEMENT;
    }

    @Override
    public boolean contributeToMap(Map<String, Tag> map) {
        TagResolver.WithoutArguments withoutArguments = this.resolver;
        if (withoutArguments instanceof MappableResolver) {
            MappableResolver mappableResolver = (MappableResolver)((Object)withoutArguments);
            return mappableResolver.contributeToMap(map);
        }
        return false;
    }

    @Override
    public void handle(Component serializable, ClaimConsumer consumer) {
        TagResolver.WithoutArguments withoutArguments = this.resolver;
        if (withoutArguments instanceof SerializableResolver) {
            SerializableResolver serializableResolver = (SerializableResolver)((Object)withoutArguments);
            serializableResolver.handle(serializable, consumer);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CachingTagResolver)) {
            return false;
        }
        CachingTagResolver that = (CachingTagResolver)other;
        return Objects.equals(this.resolver, that.resolver);
    }

    public int hashCode() {
        return Objects.hash(this.resolver);
    }
}

