/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collector;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.TagInternals;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.CachingTagResolver;
import net.kyori.adventure.text.minimessage.tag.resolver.EmptyTagResolver;
import net.kyori.adventure.text.minimessage.tag.resolver.SingleResolver;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolverBuilderImpl;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.jspecify.annotations.Nullable;

public interface TagResolver {
    public static Builder builder() {
        return new TagResolverBuilderImpl();
    }

    public static TagResolver standard() {
        return StandardTags.defaults();
    }

    public static TagResolver empty() {
        return EmptyTagResolver.INSTANCE;
    }

    public static Single resolver(@TagPattern String name, Tag tag) {
        TagInternals.assertValidTagName(name);
        return new SingleResolver(name, Objects.requireNonNull(tag, "tag"));
    }

    public static TagResolver resolver(@TagPattern String name, BiFunction<ArgumentQueue, Context, Tag> handler) {
        return TagResolver.resolver(Collections.singleton(name), handler);
    }

    public static TagResolver resolver(final Set<String> names, final BiFunction<ArgumentQueue, Context, Tag> handler) {
        HashSet<String> ownNames = new HashSet<String>(names);
        for (String name : ownNames) {
            TagInternals.assertValidTagName(name);
        }
        Objects.requireNonNull(handler, "handler");
        return new TagResolver(){

            @Override
            public @Nullable Tag resolve(String name, ArgumentQueue arguments, Context ctx) throws ParsingException {
                if (!names.contains(name)) {
                    return null;
                }
                return (Tag)handler.apply(arguments, ctx);
            }

            @Override
            public boolean has(String name) {
                return names.contains(name);
            }
        };
    }

    public static TagResolver resolver(TagResolver ... resolvers) {
        if (Objects.requireNonNull(resolvers, "resolvers").length == 1) {
            return Objects.requireNonNull(resolvers[0], "resolvers must not contain null elements");
        }
        return TagResolver.builder().resolvers(resolvers).build();
    }

    public static TagResolver resolver(Iterable<? extends TagResolver> resolvers) {
        if (resolvers instanceof Collection) {
            int size = ((Collection)resolvers).size();
            if (size == 0) {
                return TagResolver.empty();
            }
            if (size == 1) {
                return Objects.requireNonNull(resolvers.iterator().next(), "resolvers must not contain null elements");
            }
        }
        return TagResolver.builder().resolvers(resolvers).build();
    }

    public static TagResolver caching(WithoutArguments resolver) {
        if (resolver instanceof CachingTagResolver) {
            return resolver;
        }
        return new CachingTagResolver(Objects.requireNonNull(resolver, "resolver"));
    }

    public static Collector<TagResolver, ?, TagResolver> toTagResolver() {
        return TagResolverBuilderImpl.COLLECTOR;
    }

    public @Nullable Tag resolve(@TagPattern String var1, ArgumentQueue var2, Context var3) throws ParsingException;

    public boolean has(String var1);

    public static interface Builder {
        public Builder tag(@TagPattern String var1, Tag var2);

        default public Builder tag(@TagPattern String name, BiFunction<ArgumentQueue, Context, Tag> handler) {
            return this.tag(Collections.singleton(name), handler);
        }

        default public Builder tag(Set<String> names, BiFunction<ArgumentQueue, Context, Tag> handler) {
            return this.resolver(TagResolver.resolver(names, handler));
        }

        public Builder resolver(TagResolver var1);

        public Builder resolvers(TagResolver ... var1);

        public Builder resolvers(Iterable<? extends TagResolver> var1);

        default public Builder caching(WithoutArguments dynamic) {
            return this.resolver(TagResolver.caching(dynamic));
        }

        public TagResolver build();
    }

    @FunctionalInterface
    public static interface WithoutArguments
    extends TagResolver {
        public @Nullable Tag resolve(@TagPattern String var1);

        @Override
        default public boolean has(String name) {
            return this.resolve(name) != null;
        }

        @Override
        default public @Nullable Tag resolve(@TagPattern String name, ArgumentQueue arguments, Context ctx) throws ParsingException {
            Tag resolved = this.resolve(name);
            if (resolved != null && arguments.hasNext()) {
                throw ctx.newException("Tag '<" + name + ">' does not accept any arguments");
            }
            return resolved;
        }
    }

    public static sealed interface Single
    extends WithoutArguments
    permits SingleResolver {
        public String key();

        public Tag tag();

        @Override
        default public @Nullable Tag resolve(@TagPattern String name) {
            if (this.has(name)) {
                return this.tag();
            }
            return null;
        }

        @Override
        default public boolean has(String name) {
            return name.equalsIgnoreCase(this.key());
        }
    }
}

