/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.util.List;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.VirtualComponent;
import net.kyori.adventure.text.VirtualComponentRenderer;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.internal.parser.node.TagNode;
import net.kyori.adventure.text.minimessage.internal.parser.node.ValueNode;
import net.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import net.kyori.adventure.text.minimessage.internal.serializer.TokenEmitter;
import net.kyori.adventure.text.minimessage.tag.Inserting;
import net.kyori.adventure.text.minimessage.tag.Modifying;
import net.kyori.adventure.text.minimessage.tree.Node;
import org.jetbrains.annotations.UnknownNullability;
import org.jspecify.annotations.Nullable;

abstract class AbstractColorChangingTag
implements Modifying {
    private static final ComponentFlattener LENGTH_CALCULATOR = (ComponentFlattener)ComponentFlattener.builder().mapper(TextComponent.class, TextComponent::content).unknownMapper(x -> "_").build();
    private boolean visited;
    private int size = 0;
    private int disableApplyingColorDepth = -1;
    private final boolean emitVirtuals;

    AbstractColorChangingTag(Context ctx) {
        this.emitVirtuals = ctx.emitVirtuals();
    }

    protected final int size() {
        return this.size;
    }

    @Override
    public final void visit(Node current, int depth) {
        TagNode tag;
        if (this.visited) {
            throw new IllegalStateException("Color changing tag instances cannot be re-used, return a new one for each resolve");
        }
        if (current instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)current;
            String value = valueNode.value();
            this.size += value.codePointCount(0, value.length());
        } else if (current instanceof TagNode && (tag = (TagNode)current).tag() instanceof Inserting) {
            LENGTH_CALCULATOR.flatten(((Inserting)tag.tag()).value(), s -> this.size += s.codePointCount(0, s.length()));
        }
    }

    @Override
    public final void postVisit() {
        this.visited = true;
        this.init();
    }

    @Override
    public final Component apply(Component current, int depth) {
        TextComponent textComponent;
        if (this.emitVirtuals && depth == 0) {
            return Component.virtual(Void.class, (VirtualComponentRenderer)new TagInfoHolder(this.preserveData(), current), (Style)current.style());
        }
        if (this.disableApplyingColorDepth != -1 && depth > this.disableApplyingColorDepth || current.style().color() != null) {
            if (this.disableApplyingColorDepth == -1 || depth < this.disableApplyingColorDepth) {
                this.disableApplyingColorDepth = depth;
            }
            if (current instanceof TextComponent) {
                TextComponent textComponent2 = (TextComponent)current;
                this.skipColorForLengthOf(textComponent2.content());
            }
            return current.children(List.of());
        }
        this.disableApplyingColorDepth = -1;
        if (current instanceof VirtualComponent) {
            VirtualComponent virtualComponent = (VirtualComponent)current;
            this.skipColorForLengthOf(virtualComponent.content());
            return current.children(List.of());
        }
        if (current instanceof TextComponent && !(textComponent = (TextComponent)current).content().isEmpty()) {
            String content = textComponent.content();
            TextComponent.Builder parent = Component.text();
            int[] holder = new int[1];
            PrimitiveIterator.OfInt it = content.codePoints().iterator();
            while (it.hasNext()) {
                holder[0] = it.nextInt();
                TextComponent comp = Component.text((String)new String(holder, 0, 1), (Style)current.style().color(this.color()));
                this.advanceColor();
                parent.append((Component)comp);
            }
            return parent.build();
        }
        if (!(current instanceof TextComponent)) {
            Component ret = current.children(List.of()).colorIfAbsent(this.color());
            this.advanceColor();
            return ret;
        }
        return Component.empty().mergeStyle(current);
    }

    private void skipColorForLengthOf(String content) {
        int len = content.codePointCount(0, content.length());
        for (int i = 0; i < len; ++i) {
            this.advanceColor();
        }
    }

    protected abstract void init();

    protected abstract void advanceColor();

    protected abstract TextColor color();

    protected abstract Consumer<TokenEmitter> preserveData();

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract String toString();

    static @Nullable Emitable claimComponent(Component comp) {
        if (!(comp instanceof VirtualComponent)) {
            return null;
        }
        VirtualComponent virtualComponent = (VirtualComponent)comp;
        VirtualComponentRenderer holder = virtualComponent.renderer();
        if (!(holder instanceof TagInfoHolder)) {
            return null;
        }
        TagInfoHolder tagInfoHolder = (TagInfoHolder)holder;
        return tagInfoHolder;
    }

    private record TagInfoHolder(Consumer<TokenEmitter> output, Component substitute) implements VirtualComponentRenderer<Void>,
    Emitable
    {
        public @UnknownNullability ComponentLike apply(Void context) {
            return this.substitute;
        }

        public String fallbackString() {
            return "";
        }

        @Override
        public void emit(TokenEmitter emitter) {
            this.output.accept(emitter);
        }
    }
}

