/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.QuotingOverride;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.internal.serializer.StyleClaim;
import net.kyori.adventure.text.minimessage.internal.serializer.TokenEmitter;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jspecify.annotations.Nullable;

record ClickTag() {
    static final String CLICK = "click";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("click", ClickTag::create, StyleClaim.claim("click", Style::clickEvent, (event, emitter) -> {
        ClickEvent.Payload.Custom custom;
        BinaryTagHolder nbt;
        ClickEvent.Payload payload = event.payload();
        TokenEmitter tokenEmitter = emitter.tag(CLICK).argument((String)ClickEvent.Action.NAMES.keyOrThrow((Object)event.action()));
        ClickEvent.Payload payload2 = payload;
        Objects.requireNonNull(payload2);
        ClickEvent.Payload selector0$temp = payload2;
        int index$1 = 0;
        tokenEmitter.argument(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.Payload.Custom.class, ClickEvent.Payload.Dialog.class, ClickEvent.Payload.Int.class, ClickEvent.Payload.Text.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ClickEvent.Payload.Custom custom = (ClickEvent.Payload.Custom)selector0$temp;
                yield custom.key().asString();
            }
            case 1 -> {
                ClickEvent.Payload.Dialog ignored = (ClickEvent.Payload.Dialog)selector0$temp;
                throw new UnsupportedOperationException("show_dialog click events cannot be serialized by MiniMessage yet");
            }
            case 2 -> {
                ClickEvent.Payload.Int integer = (ClickEvent.Payload.Int)selector0$temp;
                yield String.valueOf(integer.integer());
            }
            case 3 -> {
                ClickEvent.Payload.Text text = (ClickEvent.Payload.Text)selector0$temp;
                yield text.value();
            }
        }, QuotingOverride.QUOTED);
        if (payload instanceof ClickEvent.Payload.Custom && (nbt = (custom = (ClickEvent.Payload.Custom)payload).nbt()) != null) {
            emitter.argument(nbt.string());
        }
    }));

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        String actionName = args.popOr(() -> "A click tag requires an action of one of " + String.valueOf(ClickEvent.Action.NAMES.keys())).lowerValue();
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ClickEvent.Action action = (ClickEvent.Action)ClickEvent.Action.NAMES.value((Object)actionName);
        if (action == null) {
            throw ctx.newException("Unknown click event action '" + actionName + "'", args);
        }
        ClickEvent.Action action2 = action;
        Objects.requireNonNull(action2);
        ClickEvent.Action action3 = action2;
        int n = 0;
        ClickEvent event = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.Action.ChangePage.class, ClickEvent.Action.Custom.class, ClickEvent.Action.ShowDialog.class, ClickEvent.Action.TextCarrier.class}, (Object)action3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ClickEvent var7_7;
                ClickEvent.Action.ChangePage ignored = (ClickEvent.Action.ChangePage)action3;
                yield var7_7 = ClickEvent.changePage((int)args.popOr("'change_page' click event requires a page argument").asInt().orElseThrow(() -> ctx.newException("'change_page' click event requires an integer page argument", args)));
            }
            case 1 -> {
                Key key;
                ClickEvent var7_7;
                ClickEvent.Action.Custom ignored = (ClickEvent.Action.Custom)action3;
                String keyString = args.popOr("'custom' click event requires a key argument").value();
                try {
                    key = Key.key((String)keyString);
                }
                catch (InvalidKeyException ex) {
                    throw ctx.newException("'custom' click event requires a valid key argument", ex, args);
                }
                String nbt = args.hasNext() ? args.pop().value() : null;
                yield var7_7 = ClickEvent.custom((Key)key, (BinaryTagHolder)(nbt == null ? null : BinaryTagHolder.binaryTagHolder((String)nbt)));
            }
            case 2 -> {
                ClickEvent.Action.ShowDialog ignored = (ClickEvent.Action.ShowDialog)action3;
                throw ctx.newException("'show_dialog' click events are not supported in MiniMessage yet");
            }
            case 3 -> {
                ClickEvent var7_7;
                ClickEvent.Action.TextCarrier textCarrier = (ClickEvent.Action.TextCarrier)action3;
                yield var7_7 = ClickEvent.clickEvent((ClickEvent.Action)textCarrier, (ClickEvent.Payload)ClickEvent.Payload.string((String)args.popOr("'" + String.valueOf(textCarrier) + "' click events require a value").value()));
            }
        };
        return Tag.styling(new StyleBuilderApplicable[]{event});
    }
}

