/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.SpriteObjectContents;
import org.jspecify.annotations.Nullable;

final class SpriteTag {
    static final String SPRITE = "sprite";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent("sprite", SpriteTag::create, SpriteTag::claimComponent);

    private SpriteTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        String secondArg;
        String firstArg = args.popOr("An atlas id and or a sprite id is required to produce a sprite object component").value();
        String string = secondArg = args.hasNext() ? args.pop().value() : null;
        if (secondArg == null) {
            return Tag.selfClosingInserting((Component)Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)firstArg))));
        }
        return Tag.selfClosingInserting((Component)Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)firstArg), (Key)Key.key((String)secondArg))));
    }

    static @Nullable Emitable claimComponent(Component input) {
        if (!(input instanceof ObjectComponent)) {
            return null;
        }
        ObjectComponent objectComponent = (ObjectComponent)input;
        ObjectContents contents = objectComponent.contents();
        if (!(contents instanceof SpriteObjectContents)) {
            return null;
        }
        SpriteObjectContents sprite = (SpriteObjectContents)contents;
        Key atlas = sprite.atlas();
        Key key = sprite.sprite();
        if (atlas == SpriteObjectContents.DEFAULT_ATLAS) {
            return emit -> emit.tag(SPRITE).argument(key.asString());
        }
        return emit -> emit.tag(SPRITE).argument(atlas.asString()).argument(key.asString());
    }
}

