/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.util.Objects;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.ClickTag;
import net.kyori.adventure.text.minimessage.tag.standard.ColorTagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.DecorationTag;
import net.kyori.adventure.text.minimessage.tag.standard.FontTag;
import net.kyori.adventure.text.minimessage.tag.standard.GradientTag;
import net.kyori.adventure.text.minimessage.tag.standard.HoverTag;
import net.kyori.adventure.text.minimessage.tag.standard.InsertionTag;
import net.kyori.adventure.text.minimessage.tag.standard.KeybindTag;
import net.kyori.adventure.text.minimessage.tag.standard.NbtTag;
import net.kyori.adventure.text.minimessage.tag.standard.NewlineTag;
import net.kyori.adventure.text.minimessage.tag.standard.PrideTag;
import net.kyori.adventure.text.minimessage.tag.standard.RainbowTag;
import net.kyori.adventure.text.minimessage.tag.standard.ResetTag;
import net.kyori.adventure.text.minimessage.tag.standard.ScoreTag;
import net.kyori.adventure.text.minimessage.tag.standard.SelectorTag;
import net.kyori.adventure.text.minimessage.tag.standard.SequentialHeadTag;
import net.kyori.adventure.text.minimessage.tag.standard.ShadowColorTag;
import net.kyori.adventure.text.minimessage.tag.standard.SpriteTag;
import net.kyori.adventure.text.minimessage.tag.standard.TransitionTag;
import net.kyori.adventure.text.minimessage.tag.standard.TranslatableFallbackTag;
import net.kyori.adventure.text.minimessage.tag.standard.TranslatableTag;

public final class StandardTags {
    private static final TagResolver ALL = TagResolver.builder().resolvers(HoverTag.RESOLVER, ClickTag.RESOLVER, ColorTagResolver.INSTANCE, KeybindTag.RESOLVER, TranslatableTag.RESOLVER, TranslatableFallbackTag.RESOLVER, InsertionTag.RESOLVER, FontTag.RESOLVER, DecorationTag.RESOLVER, GradientTag.RESOLVER, RainbowTag.RESOLVER, ResetTag.RESOLVER, NewlineTag.RESOLVER, TransitionTag.RESOLVER, SelectorTag.RESOLVER, ScoreTag.RESOLVER, NbtTag.RESOLVER, PrideTag.RESOLVER, ShadowColorTag.RESOLVER, SpriteTag.RESOLVER, SequentialHeadTag.RESOLVER).build();

    private StandardTags() {
    }

    public static TagResolver decorations(TextDecoration decoration) {
        return Objects.requireNonNull(DecorationTag.RESOLVERS.get(decoration), "No resolver found for decoration (this should not be possible?)");
    }

    public static TagResolver decorations() {
        return DecorationTag.RESOLVER;
    }

    public static TagResolver color() {
        return ColorTagResolver.INSTANCE;
    }

    public static TagResolver hoverEvent() {
        return HoverTag.RESOLVER;
    }

    public static TagResolver clickEvent() {
        return ClickTag.RESOLVER;
    }

    public static TagResolver keybind() {
        return KeybindTag.RESOLVER;
    }

    public static TagResolver sequentialHead() {
        return SequentialHeadTag.RESOLVER;
    }

    public static TagResolver translatable() {
        return TranslatableTag.RESOLVER;
    }

    public static TagResolver translatableFallback() {
        return TranslatableFallbackTag.RESOLVER;
    }

    public static TagResolver insertion() {
        return InsertionTag.RESOLVER;
    }

    public static TagResolver font() {
        return FontTag.RESOLVER;
    }

    public static TagResolver gradient() {
        return GradientTag.RESOLVER;
    }

    public static TagResolver rainbow() {
        return RainbowTag.RESOLVER;
    }

    public static TagResolver transition() {
        return TransitionTag.RESOLVER;
    }

    public static TagResolver reset() {
        return ResetTag.RESOLVER;
    }

    public static TagResolver newline() {
        return NewlineTag.RESOLVER;
    }

    public static TagResolver selector() {
        return SelectorTag.RESOLVER;
    }

    public static TagResolver score() {
        return ScoreTag.RESOLVER;
    }

    public static TagResolver nbt() {
        return NbtTag.RESOLVER;
    }

    public static TagResolver pride() {
        return PrideTag.RESOLVER;
    }

    public static TagResolver shadowColor() {
        return ShadowColorTag.RESOLVER;
    }

    public static TagResolver sprite() {
        return SpriteTag.RESOLVER;
    }

    public static TagResolver defaults() {
        return ALL;
    }
}

