/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalDouble;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Inserting;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.ColorTagResolver;
import net.kyori.adventure.util.RGBLike;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
record TransitionTag(TextColor[] colors, float phase, boolean negativePhase) implements Inserting
{
    @ApiStatus.Internal
    public static final String TRANSITION = "transition";
    static final TagResolver RESOLVER = TagResolver.resolver("transition", TransitionTag::create);

    static Tag create(ArgumentQueue args, Context ctx) {
        boolean negativePhase;
        List<TextColor> textColors;
        float phase = 0.0f;
        if (args.hasNext()) {
            textColors = new ArrayList();
            while (args.hasNext()) {
                OptionalDouble possiblePhase;
                Tag.Argument arg = args.pop();
                String argValue = arg.value();
                TextColor color = ColorTagResolver.resolveColorOrNull(argValue);
                if (color != null) {
                    textColors.add(color);
                    continue;
                }
                if (!args.hasNext() && (possiblePhase = arg.asDouble()).isPresent()) {
                    phase = (float)possiblePhase.getAsDouble();
                    if (!(phase < -1.0f) && !(phase > 1.0f)) break;
                    throw ctx.newException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0f, 1.0f] (inclusive).", Float.valueOf(phase)), args);
                }
                throw ctx.newException(String.format("Unable to parse a color from '%s'. Please use named colors or hex (#RRGGBB) colors.", argValue), args);
            }
            if (textColors.size() < 2) {
                throw ctx.newException("Invalid transition, not enough colors. Transitions must have at least two colors.", args);
            }
        } else {
            textColors = List.of();
        }
        if (phase < 0.0f) {
            negativePhase = true;
            phase = 1.0f + phase;
            Collections.reverse(textColors);
        } else {
            negativePhase = false;
        }
        TextColor[] colorsArray = textColors.isEmpty() ? new TextColor[]{TextColor.color((int)0xFFFFFF), TextColor.color((int)0)} : textColors.toArray(new TextColor[0]);
        return new TransitionTag(colorsArray, phase, negativePhase);
    }

    @Override
    public Component value() {
        return Component.text((String)"", (TextColor)this.color());
    }

    private TextColor color() {
        float steps = 1.0f / (float)(this.colors.length - 1);
        for (int colorIndex = 1; colorIndex < this.colors.length; ++colorIndex) {
            float val = (float)colorIndex * steps;
            if (!(val >= this.phase)) continue;
            float factor = 1.0f + (this.phase - val) * (float)(this.colors.length - 1);
            if (this.negativePhase) {
                return TextColor.lerp((float)(1.0f - factor), (RGBLike)this.colors[colorIndex], (RGBLike)this.colors[colorIndex - 1]);
            }
            return TextColor.lerp((float)factor, (RGBLike)this.colors[colorIndex - 1], (RGBLike)this.colors[colorIndex]);
        }
        return this.colors[0];
    }
}

