/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.TranslatableFallbackTag;
import org.jspecify.annotations.Nullable;

final class TranslatableTag {
    static final String TR = "tr";
    static final String TRANSLATE = "translate";
    static final String LANG = "lang";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(Set.of("lang", "translate", "tr"), TranslatableTag::create, TranslatableTag::claim);

    private TranslatableTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        String key = args.popOr("A translation key is required").value();
        return Tag.inserting((Component)Component.translatable((String)key, TranslatableFallbackTag.constructWith(args, ctx)));
    }

    static @Nullable Emitable claim(Component input) {
        TranslatableComponent tr;
        if (!(input instanceof TranslatableComponent) || (tr = (TranslatableComponent)input).fallback() != null) {
            return null;
        }
        return emit -> {
            emit.tag(LANG);
            emit.argument(tr.key());
            for (TranslationArgument with : tr.arguments()) {
                emit.argument(with.asComponent());
            }
        };
    }
}

