/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.translation;

import java.util.Objects;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.TranslationArgumentLike;
import net.kyori.adventure.text.VirtualComponentRenderer;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorArgument;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorTarget;

public final class Argument {
    private Argument() {
    }

    public static ComponentLike bool(@TagPattern String name, boolean value) {
        return Argument.argument(name, TranslationArgument.bool((boolean)value));
    }

    public static ComponentLike numeric(@TagPattern String name, Number value) {
        return Argument.argument(name, TranslationArgument.numeric((Number)value));
    }

    public static ComponentLike string(@TagPattern String name, String value) {
        return Argument.argument(name, TranslationArgument.component((ComponentLike)Component.text((String)value)));
    }

    public static ComponentLike component(@TagPattern String name, ComponentLike value) {
        return Argument.argument(name, TranslationArgument.component((ComponentLike)value));
    }

    public static ComponentLike argument(@TagPattern String name, TranslationArgumentLike argument) {
        return Argument.argument(name, Objects.requireNonNull(argument, "argument").asTranslationArgument());
    }

    public static ComponentLike argument(@TagPattern String name, TranslationArgument argument) {
        return Component.virtual(Void.class, new MiniMessageTranslatorArgument<TranslationArgument>(name, Objects.requireNonNull(argument, "argument")));
    }

    public static ComponentLike tag(@TagPattern String name, Tag tag) {
        return Component.virtual(Void.class, new MiniMessageTranslatorArgument<Tag>(name, Objects.requireNonNull(tag, "tag")));
    }

    public static ComponentLike tagResolver(TagResolver ... resolvers) {
        return Argument.tagResolver(TagResolver.resolver(resolvers));
    }

    public static ComponentLike tagResolver(Iterable<TagResolver> resolvers) {
        return Argument.tagResolver(TagResolver.resolver(resolvers));
    }

    public static ComponentLike tagResolver(TagResolver tagResolver) {
        return Component.virtual(Void.class, new MiniMessageTranslatorArgument<TagResolver>("unused", Objects.requireNonNull(tagResolver, "tagResolver")));
    }

    public static ComponentLike target(Pointered target) {
        return Component.virtual(Void.class, (VirtualComponentRenderer)new MiniMessageTranslatorTarget(Objects.requireNonNull(target, "target")));
    }
}

