/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.translation;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.TranslationArgumentLike;
import net.kyori.adventure.text.VirtualComponent;
import net.kyori.adventure.text.VirtualComponentRenderer;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.ArgumentTag;
import net.kyori.adventure.text.minimessage.translation.LocalePointered;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorArgument;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorTarget;
import net.kyori.adventure.translation.Translator;
import org.jspecify.annotations.Nullable;

public abstract class MiniMessageTranslator
implements Translator {
    private final MiniMessage miniMessage;

    public MiniMessageTranslator() {
        this(MiniMessage.miniMessage());
    }

    public MiniMessageTranslator(MiniMessage miniMessage) {
        this.miniMessage = Objects.requireNonNull(miniMessage, "miniMessage");
    }

    protected abstract @Nullable String getMiniMessageString(String var1, Locale var2);

    public final @Nullable MessageFormat translate(String key, Locale locale) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final @Nullable Component translate(TranslatableComponent component, Locale locale) {
        Component resultingComponent;
        String miniMessageString = this.getMiniMessageString(component.key(), locale);
        if (miniMessageString == null) {
            return null;
        }
        LocalePointered target = new LocalePointered(locale);
        List translationArguments = component.arguments();
        if (translationArguments.isEmpty()) {
            resultingComponent = this.miniMessage.deserialize(miniMessageString, target);
        } else {
            TagResolver.Builder tagResolverBuilder = TagResolver.builder();
            ArrayList<Tag> indexedArguments = new ArrayList<Tag>(translationArguments.size());
            boolean targetAlreadyOverridden = false;
            block7: for (TranslationArgument argument : translationArguments) {
                Object value = argument.value();
                if (value instanceof VirtualComponent) {
                    VirtualComponent virtual = (VirtualComponent)value;
                    VirtualComponentRenderer renderer = virtual.renderer();
                    if (renderer instanceof MiniMessageTranslatorTarget) {
                        MiniMessageTranslatorTarget translatorTarget = (MiniMessageTranslatorTarget)renderer;
                        if (targetAlreadyOverridden) {
                            throw new IllegalArgumentException("Multiple Argument.target() translation arguments have been set!");
                        }
                        target = translatorTarget.pointered();
                        targetAlreadyOverridden = true;
                        continue;
                    }
                    if (renderer instanceof MiniMessageTranslatorArgument) {
                        String string;
                        String data;
                        String name;
                        String string2;
                        MiniMessageTranslatorArgument miniMessageTranslatorArgument = (MiniMessageTranslatorArgument)renderer;
                        try {
                            name = string2 = miniMessageTranslatorArgument.name();
                            string = data = (string2 = miniMessageTranslatorArgument.data());
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        Objects.requireNonNull(string);
                        string2 = string;
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TranslationArgumentLike.class, Tag.class, TagResolver.class}, (Object)string2, n)) {
                            case 0: {
                                TranslationArgumentLike translationArgumentLike = (TranslationArgumentLike)string2;
                                Tag tag = Tag.selfClosingInserting((ComponentLike)translationArgumentLike);
                                tagResolverBuilder.tag(name, tag);
                                indexedArguments.add(tag);
                                continue block7;
                            }
                            case 1: {
                                Tag tag = (Tag)((Object)string2);
                                tagResolverBuilder.tag(name, tag);
                                indexedArguments.add(tag);
                                continue block7;
                            }
                            case 2: {
                                TagResolver tagResolver = (TagResolver)((Object)string2);
                                tagResolverBuilder.resolvers(tagResolver);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown translator argument type: " + String.valueOf(data.getClass()));
                            }
                        }
                    }
                }
                indexedArguments.add(Tag.selfClosingInserting((ComponentLike)argument));
            }
            resultingComponent = this.miniMessage.deserialize(miniMessageString, (Pointered)target, (TagResolver)new ArgumentTag(indexedArguments, tagResolverBuilder.build()));
        }
        Style style = component.style();
        if (!style.isEmpty()) {
            resultingComponent = resultingComponent.applyFallbackStyle(style);
        }
        return resultingComponent.append(component.children());
    }
}

