/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessageImpl;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tree.Node;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.util.PlatformAPI;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public interface MiniMessage
extends ComponentSerializer<Component, Component, String> {
    public static MiniMessage miniMessage() {
        return MiniMessageImpl.Instances.INSTANCE;
    }

    public String escapeTags(String var1);

    public String escapeTags(String var1, TagResolver var2);

    default public String escapeTags(String input, TagResolver ... tagResolvers) {
        return this.escapeTags(input, TagResolver.resolver(tagResolvers));
    }

    public String stripTags(String var1);

    public String stripTags(String var1, TagResolver var2);

    default public String stripTags(String input, TagResolver ... tagResolvers) {
        return this.stripTags(input, TagResolver.resolver(tagResolvers));
    }

    public Component deserialize(String var1, Pointered var2);

    public Component deserialize(String var1, TagResolver var2);

    public Component deserialize(String var1, Pointered var2, TagResolver var3);

    default public Component deserialize(String input, TagResolver ... tagResolvers) {
        return this.deserialize(input, TagResolver.resolver(tagResolvers));
    }

    default public Component deserialize(String input, Pointered target, TagResolver ... tagResolvers) {
        return this.deserialize(input, target, TagResolver.resolver(tagResolvers));
    }

    public Node.Root deserializeToTree(String var1);

    public Node.Root deserializeToTree(String var1, Pointered var2);

    public Node.Root deserializeToTree(String var1, TagResolver var2);

    public Node.Root deserializeToTree(String var1, Pointered var2, TagResolver var3);

    default public Node.Root deserializeToTree(String input, TagResolver ... tagResolvers) {
        return this.deserializeToTree(input, TagResolver.resolver(tagResolvers));
    }

    default public Node.Root deserializeToTree(String input, Pointered target, TagResolver ... tagResolvers) {
        return this.deserializeToTree(input, target, TagResolver.resolver(tagResolvers));
    }

    public boolean strict();

    public TagResolver tags();

    public static Builder builder() {
        return new MiniMessageImpl.BuilderImpl();
    }

    @PlatformAPI
    @ApiStatus.Internal
    public static interface Provider {
        @PlatformAPI
        @ApiStatus.Internal
        public MiniMessage miniMessage();

        @PlatformAPI
        @ApiStatus.Internal
        public Consumer<Builder> builder();
    }

    public static interface Builder
    extends AbstractBuilder<MiniMessage> {
        public Builder tags(TagResolver var1);

        public Builder editTags(Consumer<TagResolver.Builder> var1);

        public Builder strict(boolean var1);

        public Builder emitVirtuals(boolean var1);

        public Builder debug(@Nullable Consumer<String> var1);

        public Builder postProcessor(UnaryOperator<Component> var1);

        public Builder preProcessor(UnaryOperator<String> var1);

        public MiniMessage build();
    }
}

